/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.result.CommandError;
import dev.sympho.modular_commands.api.command.result.CommandFailure;
import dev.sympho.modular_commands.api.command.result.CommandFailureMessage;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.CommandSuccess;
import dev.sympho.modular_commands.api.command.result.CommandSuccessMessage;
import dev.sympho.modular_commands.api.command.result.UserNotAllowed;
import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.api.permission.NamedGroup;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.rest.util.Color;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class BaseHandler {
    public static final ResultHandler<CommandContext> DEFAULT = BaseHandler::defaultHandler;
    private static ResultHandler<CommandContext> base = DEFAULT;
    private static final Color COLOR_SUCCESS = Color.GREEN;
    private static final Color COLOR_FAILURE = Color.RED;
    private static final Color COLOR_ERROR = Color.GRAY;

    private BaseHandler() {
    }

    public static ResultHandler<CommandContext> get() {
        return base;
    }

    public static void set(ResultHandler<CommandContext> handler) {
        base = Objects.requireNonNull(handler);
    }

    private static Mono<Boolean> defaultHandler(CommandContext context, CommandResult result) {
        if (result instanceof CommandSuccess) {
            CommandSuccess success = (CommandSuccess)result;
            return BaseHandler.handleSuccess(context, success);
        }
        if (result instanceof CommandFailure) {
            CommandFailure failure = (CommandFailure)result;
            return BaseHandler.handleFailure(context, failure);
        }
        if (result instanceof CommandError) {
            CommandError error = (CommandError)result;
            return BaseHandler.handleError(context, error);
        }
        return Mono.empty();
    }

    private static Mono<Boolean> handleSuccess(CommandContext context, CommandSuccess result) {
        if (result instanceof CommandSuccessMessage) {
            CommandSuccessMessage res = (CommandSuccessMessage)result;
            String message = res.message();
            EmbedCreateSpec embed = EmbedCreateSpec.builder().title("Success").color(COLOR_SUCCESS).description(message).build();
            return context.reply(embed).thenReturn((Object)true);
        }
        return Mono.just((Object)true);
    }

    private static Mono<Boolean> handleFailure(CommandContext context, CommandFailure result) {
        String message;
        if (result instanceof UserNotAllowed) {
            UserNotAllowed res = (UserNotAllowed)result;
            Group required = res.required();
            if (required instanceof NamedGroup) {
                NamedGroup req = (NamedGroup)required;
                message = "Only users in the %s group can use this command.".formatted(req.name());
            } else {
                message = "You cannot use this command.";
            }
        } else if (result instanceof CommandFailureMessage) {
            CommandFailureMessage res = (CommandFailureMessage)result;
            message = res.message();
        } else {
            return Mono.just((Object)true);
        }
        EmbedCreateSpec embed = EmbedCreateSpec.builder().title("Error").color(COLOR_FAILURE).description(message).build();
        return context.reply(embed).thenReturn((Object)true);
    }

    private static Mono<Boolean> handleError(CommandContext context, CommandError result) {
        String message = result.message();
        EmbedCreateSpec embed = EmbedCreateSpec.builder().title("Internal Error").color(COLOR_ERROR).description(message).build();
        return context.reply(embed).thenReturn((Object)true);
    }
}

