/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.result;

import dev.sympho.modular_commands.api.command.result.CommandError;
import dev.sympho.modular_commands.api.command.result.CommandErrorException;
import dev.sympho.modular_commands.api.command.result.CommandFailure;
import dev.sympho.modular_commands.api.command.result.CommandFailureMessage;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.CommandSuccess;
import dev.sympho.modular_commands.api.command.result.CommandSuccessMessage;
import reactor.core.publisher.Mono;

public final class Results {
    public static final CommandSuccess OK = new ResultOK();
    public static final CommandFailure FAIL = new ResultFail();

    private Results() {
    }

    public static CommandSuccess ok() {
        return OK;
    }

    public static CommandResult okR() {
        return Results.ok();
    }

    public static Mono<CommandResult> okMono() {
        return Mono.just((Object)Results.ok());
    }

    public static CommandFailure fail() {
        return FAIL;
    }

    public static CommandResult failR() {
        return Results.fail();
    }

    public static Mono<CommandResult> failMono() {
        return Mono.just((Object)Results.fail());
    }

    public static CommandSuccessMessage success(String message) {
        return new ResultSuccessMessage(message);
    }

    public static CommandResult successR(String message) {
        return Results.success(message);
    }

    public static Mono<CommandResult> successMono(String message) {
        return Mono.just((Object)Results.success(message));
    }

    public static CommandFailureMessage failure(String message) {
        return new ResultFailureMessage(message);
    }

    public static CommandResult failureR(String message) {
        return Results.failure(message);
    }

    public static Mono<CommandResult> failureMono(String message) {
        return Mono.just((Object)Results.failure(message));
    }

    public static CommandError error(String message) {
        return new ResultError(message);
    }

    public static CommandResult errorR(String message) {
        return Results.error(message);
    }

    public static Mono<CommandResult> errorMono(String message) {
        return Mono.just((Object)Results.error(message));
    }

    public static CommandErrorException exception(Throwable cause) {
        return new ResultException(cause);
    }

    public static CommandResult exceptionR(Throwable cause) {
        return Results.exception(cause);
    }

    public static Mono<CommandResult> exceptionMono(Throwable cause) {
        return Mono.just((Object)Results.exception(cause));
    }

    record ResultSuccessMessage(String message) implements CommandSuccessMessage
    {
    }

    record ResultFailureMessage(String message) implements CommandFailureMessage
    {
    }

    record ResultError(String message) implements CommandError
    {
    }

    record ResultException(Throwable cause) implements CommandErrorException
    {
    }

    record ResultOK() implements CommandSuccess
    {
    }

    record ResultFail() implements CommandFailure
    {
    }
}

