/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.reply;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sympho.modular_commands.api.command.reply.CommandReplySpecGenerator;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommandReplySpecGenerator", generator="Immutables")
@Immutable
public final class CommandReplySpec
implements CommandReplySpecGenerator {
    private final Boolean privately_value;
    private final boolean privately_absent;
    private final String content_value;
    private final boolean content_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final ImmutableList<MessageCreateFields.File> files;
    private final ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private CommandReplySpec(Possible<Boolean> privately, Possible<String> content, Possible<Boolean> tts, Possible<List<EmbedCreateSpec>> embeds, ImmutableList<MessageCreateFields.File> files, ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<AllowedMentions> allowedMentions, Possible<List<LayoutComponent>> components) {
        Possible<Boolean> privately$impl = privately;
        Possible<String> content$impl = content;
        Possible<Boolean> tts$impl = tts;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        this.files = files;
        this.fileSpoilers = fileSpoilers;
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<List<LayoutComponent>> components$impl = components;
        this.privately_value = privately$impl.toOptional().orElse(null);
        this.privately_absent = privately$impl.isAbsent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<Boolean> privately() {
        return this.privately_absent ? Possible.absent() : Possible.of((Object)this.privately_value);
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public List<MessageCreateFields.File> files() {
        return this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return this.fileSpoilers;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public CommandReplySpec withPrivately(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new CommandReplySpec(newValue, this.content(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withPrivately(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new CommandReplySpec((Possible<Boolean>)newValue, this.content(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new CommandReplySpec(this.privately(), newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return new CommandReplySpec(this.privately(), (Possible<String>)newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new CommandReplySpec(this.privately(), this.content(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new CommandReplySpec(this.privately(), this.content(), (Possible<Boolean>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    @SafeVarargs
    public final CommandReplySpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    public CommandReplySpec withFiles(MessageCreateFields.File ... elements) {
        ImmutableList<MessageCreateFields.File> newValue = this.with_withFiles(elements);
        if (this.files == newValue) {
            return this;
        }
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    private ImmutableList<MessageCreateFields.File> with_withFiles(MessageCreateFields.File ... elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.File f : elements) {
            fs.add((Object)CommandReplySpec.files_copy(f));
        }
        return fs.build();
    }

    public CommandReplySpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        ImmutableList<MessageCreateFields.File> newValue = this.with_withFiles(elements);
        if (this.files == newValue) {
            return this;
        }
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.components());
    }

    private ImmutableList<MessageCreateFields.File> with_withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.File file : elements) {
            fs.add((Object)CommandReplySpec.files_copy(file));
        }
        return fs.build();
    }

    public CommandReplySpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        ImmutableList<MessageCreateFields.FileSpoiler> newValue = this.with_withFileSpoilers(elements);
        if (this.fileSpoilers == newValue) {
            return this;
        }
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components());
    }

    private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.FileSpoiler f : elements) {
            fs.add((Object)CommandReplySpec.fileSpoilers_copy(f));
        }
        return fs.build();
    }

    public CommandReplySpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        ImmutableList<MessageCreateFields.FileSpoiler> newValue = this.with_withFileSpoilers(elements);
        if (this.fileSpoilers == newValue) {
            return this;
        }
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components());
    }

    private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        ImmutableList.Builder fs = ImmutableList.builder();
        for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
            fs.add((Object)CommandReplySpec.fileSpoilers_copy(fileSpoiler));
        }
        return fs.build();
    }

    public CommandReplySpec withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components());
    }

    public CommandReplySpec withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), this.files, this.fileSpoilers, (Possible<AllowedMentions>)newValue, this.components());
    }

    public CommandReplySpec withComponents(Possible<List<LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue);
    }

    public CommandReplySpec withComponents(Iterable<LayoutComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<List<LayoutComponent>>)newValue);
    }

    @SafeVarargs
    public final CommandReplySpec withComponents(LayoutComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new CommandReplySpec(this.privately(), this.content(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<List<LayoutComponent>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CommandReplySpec && this.equalTo(0, (CommandReplySpec)another);
    }

    private boolean equalTo(int synthetic, CommandReplySpec another) {
        return this.privately().equals(another.privately()) && this.content().equals(another.content()) && this.tts().equals(another.tts()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files().equals(another.files()) && this.fileSpoilers().equals(another.fileSpoilers()) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.privately().hashCode();
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files().hashCode();
        h += (h << 5) + this.fileSpoilers().hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommandReplySpec").omitNullValues().add("privately", (Object)this.privately().toString()).add("content", (Object)this.content().toString()).add("tts", (Object)this.tts().toString()).add("embeds", (Object)Objects.toString(this.embeds_value)).add("files", (Object)this.files().toString()).add("fileSpoilers", (Object)this.fileSpoilers().toString()).add("allowedMentions", (Object)this.allowedMentions().toString()).add("components", (Object)Objects.toString(this.components_value)).toString();
    }

    static CommandReplySpec copyOf(CommandReplySpecGenerator instance) {
        if (instance instanceof CommandReplySpec) {
            return (CommandReplySpec)instance;
        }
        return CommandReplySpec.builder().from(instance).build();
    }

    public boolean isPrivatelyPresent() {
        return !this.privately_absent;
    }

    public Boolean privatelyOrElse(Boolean defaultValue) {
        return !this.privately_absent ? this.privately_value : defaultValue;
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    private static ImmutableList<MessageCreateFields.File> files_of(Collection<? extends MessageCreateFields.File> input) {
        ImmutableList.Builder fs = ImmutableList.builder();
        input.stream().map(f -> CommandReplySpec.files_copy(f)).forEach(arg_0 -> ((ImmutableList.Builder)fs).add(arg_0));
        return fs.build();
    }

    private static ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_of(Collection<? extends MessageCreateFields.FileSpoiler> input) {
        ImmutableList.Builder fs = ImmutableList.builder();
        input.stream().map(f -> CommandReplySpec.fileSpoilers_copy(f)).forEach(arg_0 -> ((ImmutableList.Builder)fs).add(arg_0));
        return fs.build();
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static MessageCreateFields.File files_copy(MessageCreateFields.File file) {
        return MessageCreateFields.File.of((String)file.name(), (InputStream)file.inputStream());
    }

    private static MessageCreateFields.FileSpoiler fileSpoilers_copy(MessageCreateFields.FileSpoiler file) {
        return MessageCreateFields.FileSpoiler.of((String)file.name(), (InputStream)file.inputStream());
    }

    @Generated(from="CommandReplySpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build CommandReplySpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="CommandReplySpecGenerator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Possible<Boolean> privately_possible = Possible.absent();
        private Possible<String> content_possible = Possible.absent();
        private Possible<Boolean> tts_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private ImmutableList.Builder<MessageCreateFields.File> files_list = ImmutableList.builder();
        private ImmutableList.Builder<MessageCreateFields.FileSpoiler> fileSpoilers_list = ImmutableList.builder();
        private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
        private List<LayoutComponent> components_list = null;

        private Builder() {
        }

        public final Builder from(CommandReplySpec instance) {
            return this.from((CommandReplySpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(CommandReplySpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.privately(instance.privately());
            this.content(instance.content());
            this.tts(instance.tts());
            this.embeds(instance.embeds());
            this.files(instance.files());
            this.fileSpoilers(instance.fileSpoilers());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder privately(Possible<Boolean> value) {
            this.privately_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder privately(Boolean value) {
            this.privately_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(String value) {
            this.content_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tts(Possible<Boolean> value) {
            this.tts_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tts(Boolean value) {
            this.tts_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
            this.embeds_list = null;
            elements.toOptional().ifPresent(e -> this.embeds_getOrCreate().addAll((Collection<EmbedCreateSpec>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Iterable<EmbedCreateSpec> elements) {
            this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder files(Iterable<? extends MessageCreateFields.File> files) {
            this.files_list = ImmutableList.builder();
            files.forEach(f -> this.files_list.add((Object)CommandReplySpec.files_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFile(MessageCreateFields.File ... files) {
            Arrays.asList(files).forEach(f -> this.files_list.add((Object)CommandReplySpec.files_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFiles(Iterable<? extends MessageCreateFields.File> files) {
            files.forEach(f -> this.files_list.add((Object)CommandReplySpec.files_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
            this.fileSpoilers_list = ImmutableList.builder();
            files.forEach(f -> this.fileSpoilers_list.add((Object)CommandReplySpec.fileSpoilers_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFileSpoiler(MessageCreateFields.FileSpoiler ... files) {
            Arrays.asList(files).forEach(f -> this.fileSpoilers_list.add((Object)CommandReplySpec.fileSpoilers_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
            files.forEach(f -> this.fileSpoilers_list.add((Object)CommandReplySpec.fileSpoilers_copy(f)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<AllowedMentions> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(AllowedMentions value) {
            this.allowedMentions_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(List<LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<List<LayoutComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<LayoutComponent>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(List<LayoutComponent> elements) {
            this.components_list = new ArrayList<LayoutComponent>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Iterable<LayoutComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public CommandReplySpec build() {
            return new CommandReplySpec(this.privately_build(), this.content_build(), this.tts_build(), this.embeds_build(), this.files_build(), this.fileSpoilers_build(), this.allowedMentions_build(), this.components_build());
        }

        private Possible<Boolean> privately_build() {
            return this.privately_possible;
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<Boolean> tts_build() {
            return this.tts_possible;
        }

        private Possible<List<EmbedCreateSpec>> embeds_build() {
            return this.embeds_list == null ? Possible.absent() : Possible.of(this.embeds_list);
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private ImmutableList<MessageCreateFields.File> files_build() {
            return this.files_list.build();
        }

        private ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_build() {
            return this.fileSpoilers_list.build();
        }

        private Possible<AllowedMentions> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<List<LayoutComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }
    }
}

