/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import dev.sympho.modular_commands.api.command.parameter.parse.ChoicesParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface NumberParser<P extends @NonNull Number, T>
extends ChoicesParser<P, T> {
    @Pure
    default public @Nullable P minimum() {
        return null;
    }

    @Pure
    default public @Nullable P maximum() {
        return null;
    }

    @Pure
    default public P verifyInRange(P value) throws InvalidArgumentException {
        P min = this.minimum();
        P max = this.maximum();
        if (min != null && ((Comparable)value).compareTo(min) < 0) {
            throw new InvalidArgumentException(value + " is below the minimum value of " + min);
        }
        if (max != null && ((Comparable)value).compareTo(max) > 0) {
            throw new InvalidArgumentException(value + " is above the maximum value of " + max);
        }
        return value;
    }

    @Override
    default public P validateRaw(P raw) throws InvalidArgumentException {
        return (P)this.verifyInRange((Number)ChoicesParser.super.validateRaw(raw));
    }
}

