/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import dev.sympho.modular_commands.api.command.parameter.parse.InputParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ChoicesParser<P, T>
extends InputParser<P, T> {
    public static final int MAX_CHOICES = 25;

    @Pure
    default public @Nullable List<Choice<P>> choices() {
        return null;
    }

    @Pure
    default public P verifyChoice(P value) throws InvalidArgumentException {
        List<Choice<P>> c = this.choices();
        if (c != null) {
            if (!c.stream().map(Choice::value).anyMatch(value::equals)) {
                throw new InvalidArgumentException("Not a valid choice");
            }
        }
        return value;
    }

    @Override
    default public P validateRaw(P raw) throws InvalidArgumentException {
        return this.verifyChoice(InputParser.super.validateRaw(raw));
    }

    public record Choice<P>(String name, P value) {
        public static <P> Choice<P> of(String name, P choice) {
            return new Choice<P>(name, choice);
        }

        public static <P, V> Map.Entry<Choice<P>, V> of(String name, P choice, V value) {
            return Map.entry(Choice.of(name, choice), value);
        }
    }
}

