/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api;

import dev.sympho.modular_commands.api.command.Command;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@FunctionalInterface
public interface CommandGroup {
    @Pure
    public Collection<Command<?>> commands();

    @SideEffectFree
    public static CommandGroup of(Collection<? extends Command<?>> commands) {
        List<? extends Command<?>> copy = List.copyOf(commands);
        return () -> copy;
    }

    @SideEffectFree
    public static CommandGroup of(Command<?> ... commands) {
        return CommandGroup.of(Arrays.asList(commands));
    }

    @SideEffectFree
    public static CommandGroup merge(Collection<CommandGroup> groups) {
        List commands = groups.stream().map(CommandGroup::commands).flatMap(Collection::stream).toList();
        return CommandGroup.of(commands);
    }
}

