package dev.sympho.modular_commands.api.command.reply;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Specification for creating a new command reply.
 * @version 1.0
 * @since 1.0
 */
@Generated(from = "CommandReplySpecGenerator", generator = "Immutables")
@SuppressWarnings({"OverloadMethodsDeclarationOrder", "all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class CommandReplySpec
    implements CommandReplySpecGenerator {
  private final Boolean privately_value;
  private final boolean privately_absent;
  private final String content_value;
  private final boolean content_absent;
  private final Boolean tts_value;
  private final boolean tts_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final ImmutableList<MessageCreateFields.File> files;
  private final ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;

  private CommandReplySpec(
      Possible<Boolean> privately,
      Possible<String> content,
      Possible<Boolean> tts,
      Possible<List<EmbedCreateSpec>> embeds,
      ImmutableList<MessageCreateFields.File> files,
      ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<AllowedMentions> allowedMentions,
      Possible<List<LayoutComponent>> components) {
    Possible<Boolean> privately$impl = privately;
    Possible<String> content$impl = content;
    Possible<Boolean> tts$impl = tts;
    Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
    this.files = files;
    this.fileSpoilers = fileSpoilers;
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.privately_value = privately$impl.toOptional().orElse(null);
    this.privately_absent = privately$impl.isAbsent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CommandReplySpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build CommandReplySpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Whether to send the reply privately. If absent, the default for the command should be used.
   * @return The value.
   */
  @Override
  public Possible<Boolean> privately() {
    return privately_absent ? Possible.absent() : Possible.of(privately_value);
  }

  /**
   * The reply message content.
   * @return The value.
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * Whether the reply should use TTS.
   * @return The value.
   */
  @Override
  public Possible<Boolean> tts() {
    return tts_absent ? Possible.absent() : Possible.of(tts_value);
  }

  /**
   * The reply embeds.
   * @return The value.
   */
  @Override
  public Possible<List<EmbedCreateSpec>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(embeds_value);
  }

  /**
   * The attached files.
   * @return The value.
   */
  @Override
  public List<MessageCreateFields.File> files() {
    return files;
  }

  /**
   * The spoiler-tagged attached files.
   * @return The value.
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    return fileSpoilers;
  }

  /**
   * The allowed mentions.
   * @return The value.
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * The message components.
   * @return The value.
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  public CommandReplySpec withPrivately(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new CommandReplySpec(
        newValue,
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withPrivately(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new CommandReplySpec(
        newValue,
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new CommandReplySpec(
        this.privately(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return new CommandReplySpec(
        this.privately(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withTts(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withTts(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
    Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withEmbeds(Iterable<EmbedCreateSpec> elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  @SafeVarargs
  public final CommandReplySpec withEmbeds(EmbedCreateSpec... elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  public CommandReplySpec withFiles(MessageCreateFields.File... elements) {
    ImmutableList<MessageCreateFields.File> newValue = with_withFiles(elements);
    if (this.files == newValue) return this;
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  private ImmutableList<MessageCreateFields.File> with_withFiles(MessageCreateFields.File... elements) {
    final ImmutableList.Builder<MessageCreateFields.File> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( files_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplySpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    ImmutableList<MessageCreateFields.File> newValue = with_withFiles(elements);
    if (this.files == newValue) return this;
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components());
  }

  private ImmutableList<MessageCreateFields.File> with_withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    final ImmutableList.Builder<MessageCreateFields.File> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( files_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplySpec withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = with_withFileSpoilers(elements);
    if (this.fileSpoilers == newValue) return this;
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components());
  }

  private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    final ImmutableList.Builder<MessageCreateFields.FileSpoiler> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( fileSpoilers_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplySpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = with_withFileSpoilers(elements);
    if (this.fileSpoilers == newValue) return this;
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components());
  }

  private ImmutableList<MessageCreateFields.FileSpoiler> with_withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    final ImmutableList.Builder<MessageCreateFields.FileSpoiler> fs = ImmutableList.builder();
    for ( final var f : elements ) {
      fs.add( fileSpoilers_copy( f ) );
    }
    return fs.build();
  }

  public CommandReplySpec withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components());
  }

  public CommandReplySpec withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components());
  }

  public CommandReplySpec withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue);
  }

  public CommandReplySpec withComponents(Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue);
  }

  @SafeVarargs
  public final CommandReplySpec withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return new CommandReplySpec(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code CommandReplySpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof CommandReplySpec
        && equalTo(0, (CommandReplySpec) another);
  }

  private boolean equalTo(int synthetic, CommandReplySpec another) {
    return this.privately().equals(another.privately())
        && this.content().equals(another.content())
        && this.tts().equals(another.tts())
        && Objects.equals(embeds_value, another.embeds_value)
        && this.files().equals(another.files())
        && this.fileSpoilers().equals(another.fileSpoilers())
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value);
  }

  /**
   * Computes a hash code from attributes: {@code privately}, {@code content}, {@code tts}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (privately().hashCode());
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (tts().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + (files().hashCode());
    h += (h << 5) + (fileSpoilers().hashCode());
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    return h;
  }

  /**
   * Prints the immutable value {@code CommandReplySpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommandReplySpec")
        .omitNullValues()
        .add("privately", privately().toString())
        .add("content", content().toString())
        .add("tts", tts().toString())
        .add("embeds", Objects.toString(embeds_value))
        .add("files", files().toString())
        .add("fileSpoilers", fileSpoilers().toString())
        .add("allowedMentions", allowedMentions().toString())
        .add("components", Objects.toString(components_value))
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommandReplySpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommandReplySpec instance
   */
  static CommandReplySpec copyOf(CommandReplySpecGenerator instance) {
    if (instance instanceof CommandReplySpec) {
      return (CommandReplySpec) instance;
    }
    return CommandReplySpec.builder()
        .from(instance)
        .build();
  }

  public boolean isPrivatelyPresent() {
    return !privately_absent;
  }

  public Boolean privatelyOrElse(Boolean defaultValue) {
    return !privately_absent ? privately_value : defaultValue;
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isTtsPresent() {
    return !tts_absent;
  }

  public Boolean ttsOrElse(Boolean defaultValue) {
    return !tts_absent ? tts_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  private static ImmutableList<MessageCreateFields.File> files_of(Collection<? extends MessageCreateFields.File> input) {
    final ImmutableList.Builder<MessageCreateFields.File> fs = ImmutableList.builder();
    input.stream().map( f -> files_copy( f ) ).forEach( fs::add );
    return fs.build();
  }

  private static ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_of(Collection<? extends MessageCreateFields.FileSpoiler> input) {
    final ImmutableList.Builder<MessageCreateFields.FileSpoiler> fs = ImmutableList.builder();
    input.stream().map( f -> fileSpoilers_copy( f ) ).forEach( fs::add );
    return fs.build();
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  /**
   * Creates a builder for {@link CommandReplySpec CommandReplySpec}.
   * <pre>
   * CommandReplySpec.builder()
   *    .privately(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link CommandReplySpec#privately() privately}
   *    .content(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link CommandReplySpec#content() content}
   *    .tts(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link CommandReplySpec#tts() tts}
   *    .embeds(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.spec.EmbedCreateSpec&amp;gt;&amp;gt;) // {@link CommandReplySpec#embeds() embeds}
   *    .files(List&amp;lt;discord4j.core.spec.MessageCreateFields.File&amp;gt;) // {@link CommandReplySpec#files() files}
   *    .fileSpoilers(List&amp;lt;discord4j.core.spec.MessageCreateFields.FileSpoiler&amp;gt;) // {@link CommandReplySpec#fileSpoilers() fileSpoilers}
   *    .allowedMentions(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.AllowedMentions&amp;gt;) // {@link CommandReplySpec#allowedMentions() allowedMentions}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;) // {@link CommandReplySpec#components() components}
   *    .build();
   * </pre>
   * @return A new CommandReplySpec builder
   */
  public static CommandReplySpec.Builder builder() {
    return new CommandReplySpec.Builder();
  }

  /**
   * Builds instances of type {@link CommandReplySpec CommandReplySpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommandReplySpecGenerator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Possible<Boolean> privately_possible = Possible.absent();
    private Possible<String> content_possible = Possible.absent();
    private Possible<Boolean> tts_possible = Possible.absent();
    private List<EmbedCreateSpec> embeds_list = null;
    private ImmutableList.Builder<MessageCreateFields.File> files_list = ImmutableList.builder();
    private ImmutableList.Builder<MessageCreateFields.FileSpoiler> fileSpoilers_list = ImmutableList.builder();
    private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommandReplySpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CommandReplySpec instance) {
      return from((CommandReplySpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code CommandReplySpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(CommandReplySpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      privately(instance.privately());
      content(instance.content());
      tts(instance.tts());
      embeds(instance.embeds());
      files(instance.files());
      fileSpoilers(instance.fileSpoilers());
      allowedMentions(instance.allowedMentions());
      components(instance.components());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder privately(Possible<Boolean> value) {
      this.privately_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder privately(Boolean value) {
      this.privately_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(Possible<String> value) {
      this.content_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(String value) {
      this.content_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder tts(Possible<Boolean> value) {
      this.tts_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder tts(Boolean value) {
      this.tts_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addEmbed(EmbedCreateSpec element) {
      embeds_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
      embeds_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
      this.embeds_list = null;
      elements.toOptional().ifPresent(e -> embeds_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(List<EmbedCreateSpec> elements) {
      this.embeds_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(Iterable<EmbedCreateSpec> elements) {
      this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder files(Iterable<? extends MessageCreateFields.File> files) {
      this.files_list = ImmutableList.builder();
      files.forEach( f -> files_list.add( files_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addFile(MessageCreateFields.File... files) {
      Arrays.asList( files ).forEach( f -> files_list.add( files_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllFiles(Iterable<? extends MessageCreateFields.File> files) {
      files.forEach( f -> files_list.add( files_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
      this.fileSpoilers_list = ImmutableList.builder();
      files.forEach( f -> fileSpoilers_list.add( fileSpoilers_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addFileSpoiler(MessageCreateFields.FileSpoiler... files) {
      Arrays.asList( files ).forEach( f -> fileSpoilers_list.add( fileSpoilers_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> files) {
      files.forEach( f -> fileSpoilers_list.add( fileSpoilers_copy( f ) ) );
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(Possible<AllowedMentions> value) {
      this.allowedMentions_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<List<LayoutComponent>> elements) {
      this.components_list = null;
      elements.toOptional().ifPresent(e -> components_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Iterable<LayoutComponent> elements) {
      this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link CommandReplySpec CommandReplySpec}.
     * @return An immutable instance of CommandReplySpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CommandReplySpec build() {
      return new CommandReplySpec(
          privately_build(),
          content_build(),
          tts_build(),
          embeds_build(),
          files_build(),
          fileSpoilers_build(),
          allowedMentions_build(),
          components_build());
    }

    private Possible<Boolean> privately_build() {
      return this.privately_possible;
    }

    private Possible<String> content_build() {
      return this.content_possible;
    }

    private Possible<Boolean> tts_build() {
      return this.tts_possible;
    }

    private Possible<List<EmbedCreateSpec>> embeds_build() {
      return this.embeds_list == null ? Possible.absent() :
          Possible.of(this.embeds_list);
    }

    private List<EmbedCreateSpec> embeds_getOrCreate() {
      if (this.embeds_list == null) {
        this.embeds_list = new ArrayList<>();
      }
      return this.embeds_list;
    }

    private ImmutableList<MessageCreateFields.File> files_build() {
      return files_list.build();
    }

    private ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers_build() {
      return fileSpoilers_list.build();
    }

    private Possible<AllowedMentions> allowedMentions_build() {
      return this.allowedMentions_possible;
    }

    private Possible<List<LayoutComponent>> components_build() {
      return this.components_list == null ? Possible.absent() :
          Possible.of(this.components_list);
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }
  }

  private static MessageCreateFields.File files_copy(MessageCreateFields.File file) {
    return MessageCreateFields.File.of( file.name(), file.inputStream() );
  }

  private static MessageCreateFields.FileSpoiler fileSpoilers_copy(MessageCreateFields.FileSpoiler file) {
    return MessageCreateFields.FileSpoiler.of( file.name(), file.inputStream() );
  }
}
