package dev.sympho.modular_commands.api.command.reply;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Specification for creating a new command reply that can be directly subscribed to to execute.
 * @version 1.0
 * @since 1.0
 */
@Generated(from = "CommandReplyMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class CommandReplyMono
    extends CommandReplyMonoGenerator {
  private final Boolean privately_value;
  private final boolean privately_absent;
  private final String content_value;
  private final boolean content_absent;
  private final Boolean tts_value;
  private final boolean tts_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final ImmutableList<MessageCreateFields.File> files;
  private final ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final ReplyManager manager;

  private CommandReplyMono(ReplyManager manager) {
    this.manager = Objects.requireNonNull(manager, "manager");
    Possible<Boolean> privately$impl = Possible.absent();
    Possible<String> content$impl = Possible.absent();
    Possible<Boolean> tts$impl = Possible.absent();
    Possible<List<EmbedCreateSpec>> embeds$impl = Possible.absent();
    this.files = ImmutableList.of();
    this.fileSpoilers = ImmutableList.of();
    Possible<AllowedMentions> allowedMentions$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.privately_value = privately$impl.toOptional().orElse(null);
    this.privately_absent = privately$impl.isAbsent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private CommandReplyMono(
      Possible<Boolean> privately,
      Possible<String> content,
      Possible<Boolean> tts,
      Possible<List<EmbedCreateSpec>> embeds,
      ImmutableList<MessageCreateFields.File> files,
      ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<AllowedMentions> allowedMentions,
      Possible<List<LayoutComponent>> components,
      ReplyManager manager) {
    Possible<Boolean> privately$impl = privately;
    Possible<String> content$impl = content;
    Possible<Boolean> tts$impl = tts;
    Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
    this.files = files;
    this.fileSpoilers = fileSpoilers;
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.manager = manager;
    this.privately_value = privately$impl.toOptional().orElse(null);
    this.privately_absent = privately$impl.isAbsent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CommandReplyMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build CommandReplyMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Whether to send the reply privately. If absent, the default for the command should be used.
   * @return The value.
   */
  @Override
  public Possible<Boolean> privately() {
    return privately_absent ? Possible.absent() : Possible.of(privately_value);
  }

  /**
   * The reply message content.
   * @return The value.
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * Whether the reply should use TTS.
   * @return The value.
   */
  @Override
  public Possible<Boolean> tts() {
    return tts_absent ? Possible.absent() : Possible.of(tts_value);
  }

  /**
   * The reply embeds.
   * @return The value.
   */
  @Override
  public Possible<List<EmbedCreateSpec>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(embeds_value);
  }

  /**
   * The attached files.
   * @return The value.
   */
  @Override
  public ImmutableList<MessageCreateFields.File> files() {
    return files;
  }

  /**
   * The spoiler-tagged attached files.
   * @return The value.
   */
  @Override
  public ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers() {
    return fileSpoilers;
  }

  /**
   * The allowed mentions.
   * @return The value.
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * The message components.
   * @return The value.
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  /**
   * The backing reply manager.
   * @return The manager.
   */
  @Override
  public ReplyManager manager() {
    return manager;
  }

  public CommandReplyMono withPrivately(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new CommandReplyMono(
        newValue,
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withPrivately(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new CommandReplyMono(
        newValue,
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new CommandReplyMono(
        this.privately(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return new CommandReplyMono(
        this.privately(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withTts(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withTts(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
    Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withEmbeds(java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  @SafeVarargs
  public final CommandReplyMono withEmbeds(EmbedCreateSpec... elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyMono#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyMono withFiles(MessageCreateFields.File... elements) {
    ImmutableList<MessageCreateFields.File> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyMono#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    ImmutableList<MessageCreateFields.File> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyMono#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyMono withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyMono#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.manager);
  }

  public CommandReplyMono withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.manager);
  }

  public CommandReplyMono withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.manager);
  }

  public CommandReplyMono withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.manager);
  }

  public CommandReplyMono withComponents(java.lang.Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.manager);
  }

  @SafeVarargs
  public final CommandReplyMono withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.manager);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommandReplyMono#manager() manager} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for manager
   * @return A modified copy of the {@code this} object
   */
  public final CommandReplyMono withManager(ReplyManager value) {
    if (this.manager == value) return this;
    ReplyManager newValue = Objects.requireNonNull(value, "manager");
    return new CommandReplyMono(
        this.privately(),
        this.content(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code CommandReplyMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof CommandReplyMono
        && equalTo(0, (CommandReplyMono) another);
  }

  private boolean equalTo(int synthetic, CommandReplyMono another) {
    return this.privately().equals(another.privately())
        && this.content().equals(another.content())
        && this.tts().equals(another.tts())
        && Objects.equals(embeds_value, another.embeds_value)
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value)
        && manager.equals(another.manager);
  }

  /**
   * Computes a hash code from attributes: {@code privately}, {@code content}, {@code tts}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code components}, {@code manager}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (privately().hashCode());
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (tts().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + manager.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommandReplyMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommandReplyMono")
        .omitNullValues()
        .add("privately", privately().toString())
        .add("content", content().toString())
        .add("tts", tts().toString())
        .add("embeds", Objects.toString(embeds_value))
        .add("files", files)
        .add("fileSpoilers", fileSpoilers)
        .add("allowedMentions", allowedMentions().toString())
        .add("components", Objects.toString(components_value))
        .add("manager", manager)
        .toString();
  }

  /**
   * Construct a new immutable {@code CommandReplyMono} instance.
   * @param manager The value for the {@code manager} attribute
   * @return An immutable CommandReplyMono instance
   */
  public static CommandReplyMono of(ReplyManager manager) {
    return new CommandReplyMono(manager);
  }

  /**
   * Creates an immutable copy of a {@link CommandReplyMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommandReplyMono instance
   */
  static CommandReplyMono copyOf(CommandReplyMonoGenerator instance) {
    if (instance instanceof CommandReplyMono) {
      return (CommandReplyMono) instance;
    }
    return CommandReplyMono.of(instance.manager())
        .withPrivately(instance.privately())
        .withContent(instance.content())
        .withTts(instance.tts())
        .withEmbeds(instance.embeds())
        .withFiles(instance.files())
        .withFileSpoilers(instance.fileSpoilers())
        .withAllowedMentions(instance.allowedMentions())
        .withComponents(instance.components());
  }

  public boolean isPrivatelyPresent() {
    return !privately_absent;
  }

  public Boolean privatelyOrElse(Boolean defaultValue) {
    return !privately_absent ? privately_value : defaultValue;
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isTtsPresent() {
    return !tts_absent;
  }

  public Boolean ttsOrElse(Boolean defaultValue) {
    return !tts_absent ? tts_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }
}
