package dev.sympho.modular_commands.api.command.reply;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.*;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Specification for editing a command reply that can be directly subscribed to to execute.
 * @version 1.0
 * @since 1.0
 */
@Generated(from = "CommandReplyEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class CommandReplyEditMono
    extends CommandReplyEditMonoGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final ImmutableList<MessageCreateFields.File> files;
  private final ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final Reply reply;

  private CommandReplyEditMono(Reply reply) {
    this.reply = java.util.Objects.requireNonNull(reply, "reply");
    Possible<java.util.Optional<String>> content$impl = Possible.absent();
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = Possible.absent();
    this.files = ImmutableList.of();
    this.fileSpoilers = ImmutableList.of();
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = Possible.absent();
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = Possible.absent();
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private CommandReplyEditMono(
      Possible<java.util.Optional<String>> content,
      Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds,
      ImmutableList<MessageCreateFields.File> files,
      ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<java.util.Optional<AllowedMentions>> allowedMentions,
      Possible<java.util.Optional<List<LayoutComponent>>> components,
      Reply reply) {
    Possible<java.util.Optional<String>> content$impl = content;
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = embeds;
    this.files = files;
    this.fileSpoilers = fileSpoilers;
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = components;
    this.reply = reply;
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CommandReplyEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build CommandReplyEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The new reply message content.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<String>> content() {
    return content_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(content_value));
  }

  /**
   * The new reply embeds.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(embeds_value));
  }

  /**
   * The new attached files.
   * @return The value.
   */
  @Override
  public ImmutableList<MessageCreateFields.File> files() {
    return files;
  }

  /**
   * The new spoiler-tagged attached files.
   * @return The value.
   */
  @Override
  public ImmutableList<MessageCreateFields.FileSpoiler> fileSpoilers() {
    return fileSpoilers;
  }

  /**
   * The new allowed mentions.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<AllowedMentions>> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(allowedMentions_value));
  }

  /**
   * The new message components.
   * @return The value.
   */
  @Override
  public Possible<java.util.Optional<List<LayoutComponent>>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(components_value));
  }

  /**
   * The backing reply.
   * @return The reply.
   */
  @Override
  public Reply reply() {
    return reply;
  }

  public CommandReplyEditMono withContent(Possible<java.util.Optional<String>> value) {
    Possible<java.util.Optional<String>> newValue = java.util.Objects.requireNonNull(value);
    return new CommandReplyEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  @Deprecated
  public CommandReplyEditMono withContent(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  public CommandReplyEditMono withContentOrNull(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  public CommandReplyEditMono withEmbeds(Possible<java.util.Optional<List<EmbedCreateSpec>>> possible) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
    return new CommandReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  @Deprecated
  public CommandReplyEditMono withEmbeds(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  public CommandReplyEditMono withEmbedsOrNull(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  @SafeVarargs
  public final CommandReplyEditMono withEmbeds(EmbedCreateSpec... elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new CommandReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyEditMono#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyEditMono withFiles(MessageCreateFields.File... elements) {
    ImmutableList<MessageCreateFields.File> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyEditMono#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyEditMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    ImmutableList<MessageCreateFields.File> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyEditMono#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyEditMono withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommandReplyEditMono#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final CommandReplyEditMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    ImmutableList<MessageCreateFields.FileSpoiler> newValue = ImmutableList.copyOf(elements);
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.reply);
  }

  public CommandReplyEditMono withAllowedMentions(Possible<java.util.Optional<AllowedMentions>> value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = java.util.Objects.requireNonNull(value);
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.reply);
  }

  @Deprecated
  public CommandReplyEditMono withAllowedMentions(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.reply);
  }

  public CommandReplyEditMono withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.reply);
  }

  public CommandReplyEditMono withComponents(Possible<java.util.Optional<List<LayoutComponent>>> possible) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Objects.requireNonNull(possible);
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.reply);
  }

  @Deprecated
  public CommandReplyEditMono withComponents(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.reply);
  }

  public CommandReplyEditMono withComponentsOrNull(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.reply);
  }

  @SafeVarargs
  public final CommandReplyEditMono withComponents(LayoutComponent... elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.reply);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommandReplyEditMono#reply() reply} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reply
   * @return A modified copy of the {@code this} object
   */
  public final CommandReplyEditMono withReply(Reply value) {
    if (this.reply == value) return this;
    Reply newValue = java.util.Objects.requireNonNull(value, "reply");
    return new CommandReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code CommandReplyEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof CommandReplyEditMono
        && equalTo(0, (CommandReplyEditMono) another);
  }

  private boolean equalTo(int synthetic, CommandReplyEditMono another) {
    return this.content().equals(another.content())
        && Objects.equals(embeds_value, another.embeds_value)
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value)
        && reply.equals(another.reply);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code components}, {@code reply}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + reply.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommandReplyEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommandReplyEditMono")
        .omitNullValues()
        .add("content", content().toString())
        .add("embeds", Objects.toString(embeds_value))
        .add("files", files)
        .add("fileSpoilers", fileSpoilers)
        .add("allowedMentions", allowedMentions().toString())
        .add("components", Objects.toString(components_value))
        .add("reply", reply)
        .toString();
  }

  /**
   * Construct a new immutable {@code CommandReplyEditMono} instance.
   * @param reply The value for the {@code reply} attribute
   * @return An immutable CommandReplyEditMono instance
   */
  public static CommandReplyEditMono of(Reply reply) {
    return new CommandReplyEditMono(reply);
  }

  /**
   * Creates an immutable copy of a {@link CommandReplyEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommandReplyEditMono instance
   */
  static CommandReplyEditMono copyOf(CommandReplyEditMonoGenerator instance) {
    if (instance instanceof CommandReplyEditMono) {
      return (CommandReplyEditMono) instance;
    }
    return CommandReplyEditMono.of(instance.reply())
        .withContent(instance.content())
        .withEmbeds(instance.embeds())
        .withFiles(instance.files())
        .withFileSpoilers(instance.fileSpoilers())
        .withAllowedMentions(instance.allowedMentions())
        .withComponents(instance.components());
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }
}
