package dev.sympho.modular_commands.api.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.permission.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Command}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new Command.Builder()}.
 */
@Generated(from = "Command", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableCommand<H extends dev.sympho.modular_commands.api.command.handler.@NonNull Handlers>
    implements Command<H> {
  private final String id;
  private final Command.Scope scope;
  private final boolean callable;
  private final Invocation parent;
  private final java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name;
  private final ImmutableSet<String> aliases;
  private final java.lang.@MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String displayName;
  private final java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description;
  private final ImmutableList<Parameter<?>> parameters;
  private final Group requiredGroup;
  private final boolean skipGroupCheckOnInteraction;
  private final boolean requireParentGroups;
  private final boolean nsfw;
  private final boolean repliesDefaultPrivate;
  private final boolean deferReply;
  private final boolean inheritSettings;
  private final boolean invokeParent;
  private final H handlers;

  private ImmutableCommand(ImmutableCommand.Builder<H> builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.displayName = builder.displayName;
    this.description = builder.description;
    this.parameters = builder.parameters.build();
    this.handlers = builder.handlers;
    if (builder.scope != null) {
      initShim.scope(builder.scope);
    }
    if (builder.callableIsSet()) {
      initShim.callable(builder.callable);
    }
    if (builder.parent != null) {
      initShim.parent(builder.parent);
    }
    if (builder.aliasesIsSet()) {
      initShim.aliases(builder.aliases.build());
    }
    if (builder.requiredGroup != null) {
      initShim.requiredGroup(builder.requiredGroup);
    }
    if (builder.skipGroupCheckOnInteractionIsSet()) {
      initShim.skipGroupCheckOnInteraction(builder.skipGroupCheckOnInteraction);
    }
    if (builder.requireParentGroupsIsSet()) {
      initShim.requireParentGroups(builder.requireParentGroups);
    }
    if (builder.nsfwIsSet()) {
      initShim.nsfw(builder.nsfw);
    }
    if (builder.repliesDefaultPrivateIsSet()) {
      initShim.repliesDefaultPrivate(builder.repliesDefaultPrivate);
    }
    if (builder.deferReplyIsSet()) {
      initShim.deferReply(builder.deferReply);
    }
    if (builder.inheritSettingsIsSet()) {
      initShim.inheritSettings(builder.inheritSettings);
    }
    if (builder.invokeParentIsSet()) {
      initShim.invokeParent(builder.invokeParent);
    }
    this.scope = initShim.scope();
    this.callable = initShim.callable();
    this.parent = initShim.parent();
    this.aliases = initShim.aliases();
    this.requiredGroup = initShim.requiredGroup();
    this.skipGroupCheckOnInteraction = initShim.skipGroupCheckOnInteraction();
    this.requireParentGroups = initShim.requireParentGroups();
    this.nsfw = initShim.nsfw();
    this.repliesDefaultPrivate = initShim.repliesDefaultPrivate();
    this.deferReply = initShim.deferReply();
    this.inheritSettings = initShim.inheritSettings();
    this.invokeParent = initShim.invokeParent();
    this.initShim = null;
  }

  private ImmutableCommand(
      String id,
      Command.Scope scope,
      boolean callable,
      Invocation parent,
      java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name,
      ImmutableSet<String> aliases,
      java.lang.@MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String displayName,
      java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description,
      ImmutableList<Parameter<?>> parameters,
      Group requiredGroup,
      boolean skipGroupCheckOnInteraction,
      boolean requireParentGroups,
      boolean nsfw,
      boolean repliesDefaultPrivate,
      boolean deferReply,
      boolean inheritSettings,
      boolean invokeParent,
      H handlers) {
    this.id = id;
    this.scope = scope;
    this.callable = callable;
    this.parent = parent;
    this.name = name;
    this.aliases = aliases;
    this.displayName = displayName;
    this.description = description;
    this.parameters = parameters;
    this.requiredGroup = requiredGroup;
    this.skipGroupCheckOnInteraction = skipGroupCheckOnInteraction;
    this.requireParentGroups = requireParentGroups;
    this.nsfw = nsfw;
    this.repliesDefaultPrivate = repliesDefaultPrivate;
    this.deferReply = deferReply;
    this.inheritSettings = inheritSettings;
    this.invokeParent = invokeParent;
    this.handlers = handlers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Command", generator = "Immutables")
  private final class InitShim {
    private byte scopeBuildStage = STAGE_UNINITIALIZED;
    private Command.Scope scope;

    Command.Scope scope() {
      if (scopeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (scopeBuildStage == STAGE_UNINITIALIZED) {
        scopeBuildStage = STAGE_INITIALIZING;
        this.scope = Objects.requireNonNull(scopeInitialize(), "scope");
        scopeBuildStage = STAGE_INITIALIZED;
      }
      return this.scope;
    }

    void scope(Command.Scope scope) {
      this.scope = scope;
      scopeBuildStage = STAGE_INITIALIZED;
    }

    private byte callableBuildStage = STAGE_UNINITIALIZED;
    private boolean callable;

    boolean callable() {
      if (callableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (callableBuildStage == STAGE_UNINITIALIZED) {
        callableBuildStage = STAGE_INITIALIZING;
        this.callable = callableInitialize();
        callableBuildStage = STAGE_INITIALIZED;
      }
      return this.callable;
    }

    void callable(boolean callable) {
      this.callable = callable;
      callableBuildStage = STAGE_INITIALIZED;
    }

    private byte parentBuildStage = STAGE_UNINITIALIZED;
    private Invocation parent;

    Invocation parent() {
      if (parentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (parentBuildStage == STAGE_UNINITIALIZED) {
        parentBuildStage = STAGE_INITIALIZING;
        this.parent = Objects.requireNonNull(parentInitialize(), "parent");
        parentBuildStage = STAGE_INITIALIZED;
      }
      return this.parent;
    }

    void parent(Invocation parent) {
      this.parent = parent;
      parentBuildStage = STAGE_INITIALIZED;
    }

    private byte aliasesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<String> aliases;

    ImmutableSet<String> aliases() {
      if (aliasesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (aliasesBuildStage == STAGE_UNINITIALIZED) {
        aliasesBuildStage = STAGE_INITIALIZING;
        this.aliases = ImmutableSet.copyOf(aliasesInitialize());
        aliasesBuildStage = STAGE_INITIALIZED;
      }
      return this.aliases;
    }

    void aliases(ImmutableSet<String> aliases) {
      this.aliases = aliases;
      aliasesBuildStage = STAGE_INITIALIZED;
    }

    private byte requiredGroupBuildStage = STAGE_UNINITIALIZED;
    private Group requiredGroup;

    Group requiredGroup() {
      if (requiredGroupBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (requiredGroupBuildStage == STAGE_UNINITIALIZED) {
        requiredGroupBuildStage = STAGE_INITIALIZING;
        this.requiredGroup = Objects.requireNonNull(requiredGroupInitialize(), "requiredGroup");
        requiredGroupBuildStage = STAGE_INITIALIZED;
      }
      return this.requiredGroup;
    }

    void requiredGroup(Group requiredGroup) {
      this.requiredGroup = requiredGroup;
      requiredGroupBuildStage = STAGE_INITIALIZED;
    }

    private byte skipGroupCheckOnInteractionBuildStage = STAGE_UNINITIALIZED;
    private boolean skipGroupCheckOnInteraction;

    boolean skipGroupCheckOnInteraction() {
      if (skipGroupCheckOnInteractionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (skipGroupCheckOnInteractionBuildStage == STAGE_UNINITIALIZED) {
        skipGroupCheckOnInteractionBuildStage = STAGE_INITIALIZING;
        this.skipGroupCheckOnInteraction = skipGroupCheckOnInteractionInitialize();
        skipGroupCheckOnInteractionBuildStage = STAGE_INITIALIZED;
      }
      return this.skipGroupCheckOnInteraction;
    }

    void skipGroupCheckOnInteraction(boolean skipGroupCheckOnInteraction) {
      this.skipGroupCheckOnInteraction = skipGroupCheckOnInteraction;
      skipGroupCheckOnInteractionBuildStage = STAGE_INITIALIZED;
    }

    private byte requireParentGroupsBuildStage = STAGE_UNINITIALIZED;
    private boolean requireParentGroups;

    boolean requireParentGroups() {
      if (requireParentGroupsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (requireParentGroupsBuildStage == STAGE_UNINITIALIZED) {
        requireParentGroupsBuildStage = STAGE_INITIALIZING;
        this.requireParentGroups = requireParentGroupsInitialize();
        requireParentGroupsBuildStage = STAGE_INITIALIZED;
      }
      return this.requireParentGroups;
    }

    void requireParentGroups(boolean requireParentGroups) {
      this.requireParentGroups = requireParentGroups;
      requireParentGroupsBuildStage = STAGE_INITIALIZED;
    }

    private byte nsfwBuildStage = STAGE_UNINITIALIZED;
    private boolean nsfw;

    boolean nsfw() {
      if (nsfwBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nsfwBuildStage == STAGE_UNINITIALIZED) {
        nsfwBuildStage = STAGE_INITIALIZING;
        this.nsfw = nsfwInitialize();
        nsfwBuildStage = STAGE_INITIALIZED;
      }
      return this.nsfw;
    }

    void nsfw(boolean nsfw) {
      this.nsfw = nsfw;
      nsfwBuildStage = STAGE_INITIALIZED;
    }

    private byte repliesDefaultPrivateBuildStage = STAGE_UNINITIALIZED;
    private boolean repliesDefaultPrivate;

    boolean repliesDefaultPrivate() {
      if (repliesDefaultPrivateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (repliesDefaultPrivateBuildStage == STAGE_UNINITIALIZED) {
        repliesDefaultPrivateBuildStage = STAGE_INITIALIZING;
        this.repliesDefaultPrivate = repliesDefaultPrivateInitialize();
        repliesDefaultPrivateBuildStage = STAGE_INITIALIZED;
      }
      return this.repliesDefaultPrivate;
    }

    void repliesDefaultPrivate(boolean repliesDefaultPrivate) {
      this.repliesDefaultPrivate = repliesDefaultPrivate;
      repliesDefaultPrivateBuildStage = STAGE_INITIALIZED;
    }

    private byte deferReplyBuildStage = STAGE_UNINITIALIZED;
    private boolean deferReply;

    boolean deferReply() {
      if (deferReplyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (deferReplyBuildStage == STAGE_UNINITIALIZED) {
        deferReplyBuildStage = STAGE_INITIALIZING;
        this.deferReply = deferReplyInitialize();
        deferReplyBuildStage = STAGE_INITIALIZED;
      }
      return this.deferReply;
    }

    void deferReply(boolean deferReply) {
      this.deferReply = deferReply;
      deferReplyBuildStage = STAGE_INITIALIZED;
    }

    private byte inheritSettingsBuildStage = STAGE_UNINITIALIZED;
    private boolean inheritSettings;

    boolean inheritSettings() {
      if (inheritSettingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (inheritSettingsBuildStage == STAGE_UNINITIALIZED) {
        inheritSettingsBuildStage = STAGE_INITIALIZING;
        this.inheritSettings = inheritSettingsInitialize();
        inheritSettingsBuildStage = STAGE_INITIALIZED;
      }
      return this.inheritSettings;
    }

    void inheritSettings(boolean inheritSettings) {
      this.inheritSettings = inheritSettings;
      inheritSettingsBuildStage = STAGE_INITIALIZED;
    }

    private byte invokeParentBuildStage = STAGE_UNINITIALIZED;
    private boolean invokeParent;

    boolean invokeParent() {
      if (invokeParentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (invokeParentBuildStage == STAGE_UNINITIALIZED) {
        invokeParentBuildStage = STAGE_INITIALIZING;
        this.invokeParent = invokeParentInitialize();
        invokeParentBuildStage = STAGE_INITIALIZED;
      }
      return this.invokeParent;
    }

    void invokeParent(boolean invokeParent) {
      this.invokeParent = invokeParent;
      invokeParentBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (scopeBuildStage == STAGE_INITIALIZING) attributes.add("scope");
      if (callableBuildStage == STAGE_INITIALIZING) attributes.add("callable");
      if (parentBuildStage == STAGE_INITIALIZING) attributes.add("parent");
      if (aliasesBuildStage == STAGE_INITIALIZING) attributes.add("aliases");
      if (requiredGroupBuildStage == STAGE_INITIALIZING) attributes.add("requiredGroup");
      if (skipGroupCheckOnInteractionBuildStage == STAGE_INITIALIZING) attributes.add("skipGroupCheckOnInteraction");
      if (requireParentGroupsBuildStage == STAGE_INITIALIZING) attributes.add("requireParentGroups");
      if (nsfwBuildStage == STAGE_INITIALIZING) attributes.add("nsfw");
      if (repliesDefaultPrivateBuildStage == STAGE_INITIALIZING) attributes.add("repliesDefaultPrivate");
      if (deferReplyBuildStage == STAGE_INITIALIZING) attributes.add("deferReply");
      if (inheritSettingsBuildStage == STAGE_INITIALIZING) attributes.add("inheritSettings");
      if (invokeParentBuildStage == STAGE_INITIALIZING) attributes.add("invokeParent");
      return "Cannot build Command, attribute initializers form cycle " + attributes;
    }
  }

  private Command.Scope scopeInitialize() {
    return Command.super.scope();
  }

  private boolean callableInitialize() {
    return Command.super.callable();
  }

  private Invocation parentInitialize() {
    return Command.super.parent();
  }

  private Set<String> aliasesInitialize() {
    return Command.super.aliases();
  }

  private Group requiredGroupInitialize() {
    return Command.super.requiredGroup();
  }

  private boolean skipGroupCheckOnInteractionInitialize() {
    return Command.super.skipGroupCheckOnInteraction();
  }

  private boolean requireParentGroupsInitialize() {
    return Command.super.requireParentGroups();
  }

  private boolean nsfwInitialize() {
    return Command.super.nsfw();
  }

  private boolean repliesDefaultPrivateInitialize() {
    return Command.super.repliesDefaultPrivate();
  }

  private boolean deferReplyInitialize() {
    return Command.super.deferReply();
  }

  private boolean inheritSettingsInitialize() {
    return Command.super.inheritSettings();
  }

  private boolean invokeParentInitialize() {
    return Command.super.invokeParent();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code scope} attribute
   */
  @Override
  public Command.Scope scope() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.scope()
        : this.scope;
  }

  /**
   * @return The value of the {@code callable} attribute
   */
  @Override
  public boolean callable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.callable()
        : this.callable;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @Override
  public Invocation parent() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.parent()
        : this.parent;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name() {
    return name;
  }

  /**
   * @return The value of the {@code aliases} attribute
   */
  @Override
  public ImmutableSet<String> aliases() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.aliases()
        : this.aliases;
  }

  /**
   * @return The value of the {@code displayName} attribute
   */
  @Override
  public java.lang.@MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String displayName() {
    return displayName;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description() {
    return description;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public ImmutableList<Parameter<?>> parameters() {
    return parameters;
  }

  /**
   * @return The value of the {@code requiredGroup} attribute
   */
  @Override
  public Group requiredGroup() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.requiredGroup()
        : this.requiredGroup;
  }

  /**
   * @return The value of the {@code skipGroupCheckOnInteraction} attribute
   */
  @Override
  public boolean skipGroupCheckOnInteraction() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.skipGroupCheckOnInteraction()
        : this.skipGroupCheckOnInteraction;
  }

  /**
   * @return The value of the {@code requireParentGroups} attribute
   */
  @Override
  public boolean requireParentGroups() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.requireParentGroups()
        : this.requireParentGroups;
  }

  /**
   * @return The value of the {@code nsfw} attribute
   */
  @Override
  public boolean nsfw() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.nsfw()
        : this.nsfw;
  }

  /**
   * @return The value of the {@code repliesDefaultPrivate} attribute
   */
  @Override
  public boolean repliesDefaultPrivate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.repliesDefaultPrivate()
        : this.repliesDefaultPrivate;
  }

  /**
   * @return The value of the {@code deferReply} attribute
   */
  @Override
  public boolean deferReply() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.deferReply()
        : this.deferReply;
  }

  /**
   * @return The value of the {@code inheritSettings} attribute
   */
  @Override
  public boolean inheritSettings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.inheritSettings()
        : this.inheritSettings;
  }

  /**
   * @return The value of the {@code invokeParent} attribute
   */
  @Override
  public boolean invokeParent() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.invokeParent()
        : this.invokeParent;
  }

  /**
   * @return The value of the {@code handlers} attribute
   */
  @Override
  public H handlers() {
    return handlers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableCommand<>(
        newValue,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#scope() scope} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scope
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withScope(Command.Scope value) {
    Command.Scope newValue = Objects.requireNonNull(value, "scope");
    if (this.scope == newValue) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        newValue,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#callable() callable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for callable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withCallable(boolean value) {
    if (this.callable == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        value,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#parent() parent} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parent
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withParent(Invocation value) {
    if (this.parent == value) return this;
    Invocation newValue = Objects.requireNonNull(value, "parent");
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        newValue,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withName(java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String value) {
    java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        newValue,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Command#aliases() aliases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommand<H> withAliases(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        newValue,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Command#aliases() aliases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of aliases elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommand<H> withAliases(Iterable<String> elements) {
    if (this.aliases == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        newValue,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#displayName() displayName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for displayName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withDisplayName(java.lang.@MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String value) {
    java.lang.@MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String newValue = Objects.requireNonNull(value, "displayName");
    if (this.displayName.equals(newValue)) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        newValue,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withDescription(java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String value) {
    java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        newValue,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Command#parameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableCommand<H> withParameters(Parameter<?>... elements) {
    ImmutableList<Parameter<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        newValue,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Command#parameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommand<H> withParameters(Iterable<? extends Parameter<?>> elements) {
    if (this.parameters == elements) return this;
    ImmutableList<Parameter<?>> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        newValue,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#requiredGroup() requiredGroup} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requiredGroup
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withRequiredGroup(Group value) {
    if (this.requiredGroup == value) return this;
    Group newValue = Objects.requireNonNull(value, "requiredGroup");
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        newValue,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#skipGroupCheckOnInteraction() skipGroupCheckOnInteraction} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for skipGroupCheckOnInteraction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withSkipGroupCheckOnInteraction(boolean value) {
    if (this.skipGroupCheckOnInteraction == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        value,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#requireParentGroups() requireParentGroups} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requireParentGroups
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withRequireParentGroups(boolean value) {
    if (this.requireParentGroups == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        value,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#nsfw() nsfw} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nsfw
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withNsfw(boolean value) {
    if (this.nsfw == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        value,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#repliesDefaultPrivate() repliesDefaultPrivate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repliesDefaultPrivate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withRepliesDefaultPrivate(boolean value) {
    if (this.repliesDefaultPrivate == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        value,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#deferReply() deferReply} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deferReply
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withDeferReply(boolean value) {
    if (this.deferReply == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        value,
        this.inheritSettings,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#inheritSettings() inheritSettings} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inheritSettings
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withInheritSettings(boolean value) {
    if (this.inheritSettings == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        value,
        this.invokeParent,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#invokeParent() invokeParent} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for invokeParent
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withInvokeParent(boolean value) {
    if (this.invokeParent == value) return this;
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        value,
        this.handlers));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Command#handlers() handlers} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for handlers
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommand<H> withHandlers(H value) {
    if (this.handlers == value) return this;
    H newValue = Objects.requireNonNull(value, "handlers");
    return validate(new ImmutableCommand<>(
        this.id,
        this.scope,
        this.callable,
        this.parent,
        this.name,
        this.aliases,
        this.displayName,
        this.description,
        this.parameters,
        this.requiredGroup,
        this.skipGroupCheckOnInteraction,
        this.requireParentGroups,
        this.nsfw,
        this.repliesDefaultPrivate,
        this.deferReply,
        this.inheritSettings,
        this.invokeParent,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommand<?>
        && equalTo(0, (ImmutableCommand<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableCommand<?> another) {
    return id.equals(another.id)
        && scope.equals(another.scope)
        && callable == another.callable
        && parent.equals(another.parent)
        && name.equals(another.name)
        && aliases.equals(another.aliases)
        && displayName.equals(another.displayName)
        && description.equals(another.description)
        && parameters.equals(another.parameters)
        && requiredGroup.equals(another.requiredGroup)
        && skipGroupCheckOnInteraction == another.skipGroupCheckOnInteraction
        && requireParentGroups == another.requireParentGroups
        && nsfw == another.nsfw
        && repliesDefaultPrivate == another.repliesDefaultPrivate
        && deferReply == another.deferReply
        && inheritSettings == another.inheritSettings
        && invokeParent == another.invokeParent
        && handlers.equals(another.handlers);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code scope}, {@code callable}, {@code parent}, {@code name}, {@code aliases}, {@code displayName}, {@code description}, {@code parameters}, {@code requiredGroup}, {@code skipGroupCheckOnInteraction}, {@code requireParentGroups}, {@code nsfw}, {@code repliesDefaultPrivate}, {@code deferReply}, {@code inheritSettings}, {@code invokeParent}, {@code handlers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + scope.hashCode();
    h += (h << 5) + Booleans.hashCode(callable);
    h += (h << 5) + parent.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + aliases.hashCode();
    h += (h << 5) + displayName.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + parameters.hashCode();
    h += (h << 5) + requiredGroup.hashCode();
    h += (h << 5) + Booleans.hashCode(skipGroupCheckOnInteraction);
    h += (h << 5) + Booleans.hashCode(requireParentGroups);
    h += (h << 5) + Booleans.hashCode(nsfw);
    h += (h << 5) + Booleans.hashCode(repliesDefaultPrivate);
    h += (h << 5) + Booleans.hashCode(deferReply);
    h += (h << 5) + Booleans.hashCode(inheritSettings);
    h += (h << 5) + Booleans.hashCode(invokeParent);
    h += (h << 5) + handlers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Command} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Command")
        .omitNullValues()
        .add("id", id)
        .add("scope", scope)
        .add("callable", callable)
        .add("parent", parent)
        .add("name", name)
        .add("aliases", aliases)
        .add("displayName", displayName)
        .add("description", description)
        .add("parameters", parameters)
        .add("requiredGroup", requiredGroup)
        .add("skipGroupCheckOnInteraction", skipGroupCheckOnInteraction)
        .add("requireParentGroups", requireParentGroups)
        .add("nsfw", nsfw)
        .add("repliesDefaultPrivate", repliesDefaultPrivate)
        .add("deferReply", deferReply)
        .add("inheritSettings", inheritSettings)
        .add("invokeParent", invokeParent)
        .add("handlers", handlers)
        .toString();
  }

  private static <H extends dev.sympho.modular_commands.api.command.handler.@NonNull Handlers> ImmutableCommand<H> validate(ImmutableCommand<H> instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Command} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <H> generic parameter H
   * @param instance The instance to copy
   * @return A copied immutable Command instance
   */
  public static <H extends dev.sympho.modular_commands.api.command.handler.@NonNull Handlers> Command<H> copyOf(Command<H> instance) {
    if (instance instanceof ImmutableCommand<?>) {
      return (ImmutableCommand<H>) instance;
    }
    return new Command.Builder<H>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link Command Command}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Command", generator = "Immutables")
  @NotThreadSafe
  public static class Builder<H extends dev.sympho.modular_commands.api.command.handler.@NonNull Handlers>
     {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_DISPLAY_NAME = 0x4L;
    private static final long INIT_BIT_DESCRIPTION = 0x8L;
    private static final long INIT_BIT_HANDLERS = 0x10L;
    private static final long OPT_BIT_CALLABLE = 0x1L;
    private static final long OPT_BIT_ALIASES = 0x2L;
    private static final long OPT_BIT_SKIP_GROUP_CHECK_ON_INTERACTION = 0x4L;
    private static final long OPT_BIT_REQUIRE_PARENT_GROUPS = 0x8L;
    private static final long OPT_BIT_NSFW = 0x10L;
    private static final long OPT_BIT_REPLIES_DEFAULT_PRIVATE = 0x20L;
    private static final long OPT_BIT_DEFER_REPLY = 0x40L;
    private static final long OPT_BIT_INHERIT_SETTINGS = 0x80L;
    private static final long OPT_BIT_INVOKE_PARENT = 0x100L;
    private long initBits = 0x1fL;
    private long optBits;

    private @Nullable String id;
    private @Nullable Command.Scope scope;
    private boolean callable;
    private @Nullable Invocation parent;
    private @Nullable java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name;
    private ImmutableSet.Builder<String> aliases = ImmutableSet.builder();
    private @Nullable java.lang.@MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String displayName;
    private @Nullable java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description;
    private ImmutableList.Builder<Parameter<?>> parameters = ImmutableList.builder();
    private @Nullable Group requiredGroup;
    private boolean skipGroupCheckOnInteraction;
    private boolean requireParentGroups;
    private boolean nsfw;
    private boolean repliesDefaultPrivate;
    private boolean deferReply;
    private boolean inheritSettings;
    private boolean invokeParent;
    private @Nullable H handlers;

    /**
     * Creates a builder for {@link Command Command} instances.
     * <pre>
     * new Command.Builder&amp;lt;H&amp;gt;()
     *    .id(String) // required {@link Command#id() id}
     *    .scope(dev.sympho.modular_commands.api.command.Command.Scope) // optional {@link Command#scope() scope}
     *    .callable(boolean) // optional {@link Command#callable() callable}
     *    .parent(dev.sympho.modular_commands.api.command.Invocation) // optional {@link Command#parent() parent}
     *    .name(@org.checkerframework.common.value.qual.MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String) // required {@link Command#name() name}
     *    .addAliases|addAllAliases(String) // {@link Command#aliases() aliases} elements
     *    .displayName(@org.checkerframework.common.value.qual.MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String) // required {@link Command#displayName() displayName}
     *    .description(@org.checkerframework.common.value.qual.MatchesRegex("(?Us)^.{1,100}+$") String) // required {@link Command#description() description}
     *    .addParameters|addAllParameters(dev.sympho.modular_commands.api.command.parameter.Parameter&amp;lt;?&amp;gt;) // {@link Command#parameters() parameters} elements
     *    .requiredGroup(dev.sympho.modular_commands.api.permission.Group) // optional {@link Command#requiredGroup() requiredGroup}
     *    .skipGroupCheckOnInteraction(boolean) // optional {@link Command#skipGroupCheckOnInteraction() skipGroupCheckOnInteraction}
     *    .requireParentGroups(boolean) // optional {@link Command#requireParentGroups() requireParentGroups}
     *    .nsfw(boolean) // optional {@link Command#nsfw() nsfw}
     *    .repliesDefaultPrivate(boolean) // optional {@link Command#repliesDefaultPrivate() repliesDefaultPrivate}
     *    .deferReply(boolean) // optional {@link Command#deferReply() deferReply}
     *    .inheritSettings(boolean) // optional {@link Command#inheritSettings() inheritSettings}
     *    .invokeParent(boolean) // optional {@link Command#invokeParent() invokeParent}
     *    .handlers(H) // required {@link Command#handlers() handlers}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof Command.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new Command.Builder<H>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code Command} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> from(Command<H> instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      scope(instance.scope());
      callable(instance.callable());
      parent(instance.parent());
      name(instance.name());
      addAllAliases(instance.aliases());
      displayName(instance.displayName());
      description(instance.description());
      addAllParameters(instance.parameters());
      requiredGroup(instance.requiredGroup());
      skipGroupCheckOnInteraction(instance.skipGroupCheckOnInteraction());
      requireParentGroups(instance.requireParentGroups());
      nsfw(instance.nsfw());
      repliesDefaultPrivate(instance.repliesDefaultPrivate());
      deferReply(instance.deferReply());
      inheritSettings(instance.inheritSettings());
      invokeParent(instance.invokeParent());
      handlers(instance.handlers());
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#scope() scope} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#scope() scope}.</em>
     * @param scope The value for scope 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> scope(Command.Scope scope) {
      this.scope = Objects.requireNonNull(scope, "scope");
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#callable() callable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#callable() callable}.</em>
     * @param callable The value for callable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> callable(boolean callable) {
      this.callable = callable;
      optBits |= OPT_BIT_CALLABLE;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#parent() parent} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#parent() parent}.</em>
     * @param parent The value for parent 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> parent(Invocation parent) {
      this.parent = Objects.requireNonNull(parent, "parent");
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> name(java.lang.@MatchesRegex("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return (Command.Builder<H>) this;
    }

    /**
     * Adds one element to {@link Command#aliases() aliases} set.
     * @param element A aliases element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> addAliases(String element) {
      this.aliases.add(element);
      optBits |= OPT_BIT_ALIASES;
      return (Command.Builder<H>) this;
    }

    /**
     * Adds elements to {@link Command#aliases() aliases} set.
     * @param elements An array of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> addAliases(String... elements) {
      this.aliases.add(elements);
      optBits |= OPT_BIT_ALIASES;
      return (Command.Builder<H>) this;
    }


    /**
     * Sets or replaces all elements for {@link Command#aliases() aliases} set.
     * @param elements An iterable of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> aliases(Iterable<String> elements) {
      this.aliases = ImmutableSet.builder();
      return addAllAliases(elements);
    }

    /**
     * Adds elements to {@link Command#aliases() aliases} set.
     * @param elements An iterable of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> addAllAliases(Iterable<String> elements) {
      this.aliases.addAll(elements);
      optBits |= OPT_BIT_ALIASES;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#displayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> displayName(java.lang.@MatchesRegex("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$") String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> description(java.lang.@MatchesRegex("(?Us)^.{1,100}+$") String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return (Command.Builder<H>) this;
    }

    /**
     * Adds one element to {@link Command#parameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> addParameters(Parameter<?> element) {
      this.parameters.add(element);
      return (Command.Builder<H>) this;
    }

    /**
     * Adds elements to {@link Command#parameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Command.Builder<H> addParameters(Parameter<?>... elements) {
      this.parameters.add(elements);
      return (Command.Builder<H>) this;
    }


    /**
     * Sets or replaces all elements for {@link Command#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> parameters(Iterable<? extends Parameter<?>> elements) {
      this.parameters = ImmutableList.builder();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link Command#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> addAllParameters(Iterable<? extends Parameter<?>> elements) {
      this.parameters.addAll(elements);
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#requiredGroup() requiredGroup} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#requiredGroup() requiredGroup}.</em>
     * @param requiredGroup The value for requiredGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> requiredGroup(Group requiredGroup) {
      this.requiredGroup = Objects.requireNonNull(requiredGroup, "requiredGroup");
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#skipGroupCheckOnInteraction() skipGroupCheckOnInteraction} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#skipGroupCheckOnInteraction() skipGroupCheckOnInteraction}.</em>
     * @param skipGroupCheckOnInteraction The value for skipGroupCheckOnInteraction 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> skipGroupCheckOnInteraction(boolean skipGroupCheckOnInteraction) {
      this.skipGroupCheckOnInteraction = skipGroupCheckOnInteraction;
      optBits |= OPT_BIT_SKIP_GROUP_CHECK_ON_INTERACTION;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#requireParentGroups() requireParentGroups} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#requireParentGroups() requireParentGroups}.</em>
     * @param requireParentGroups The value for requireParentGroups 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> requireParentGroups(boolean requireParentGroups) {
      this.requireParentGroups = requireParentGroups;
      optBits |= OPT_BIT_REQUIRE_PARENT_GROUPS;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#nsfw() nsfw} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#nsfw() nsfw}.</em>
     * @param nsfw The value for nsfw 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> nsfw(boolean nsfw) {
      this.nsfw = nsfw;
      optBits |= OPT_BIT_NSFW;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#repliesDefaultPrivate() repliesDefaultPrivate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#repliesDefaultPrivate() repliesDefaultPrivate}.</em>
     * @param repliesDefaultPrivate The value for repliesDefaultPrivate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> repliesDefaultPrivate(boolean repliesDefaultPrivate) {
      this.repliesDefaultPrivate = repliesDefaultPrivate;
      optBits |= OPT_BIT_REPLIES_DEFAULT_PRIVATE;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#deferReply() deferReply} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#deferReply() deferReply}.</em>
     * @param deferReply The value for deferReply 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> deferReply(boolean deferReply) {
      this.deferReply = deferReply;
      optBits |= OPT_BIT_DEFER_REPLY;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#inheritSettings() inheritSettings} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#inheritSettings() inheritSettings}.</em>
     * @param inheritSettings The value for inheritSettings 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> inheritSettings(boolean inheritSettings) {
      this.inheritSettings = inheritSettings;
      optBits |= OPT_BIT_INHERIT_SETTINGS;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#invokeParent() invokeParent} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Command#invokeParent() invokeParent}.</em>
     * @param invokeParent The value for invokeParent 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> invokeParent(boolean invokeParent) {
      this.invokeParent = invokeParent;
      optBits |= OPT_BIT_INVOKE_PARENT;
      return (Command.Builder<H>) this;
    }

    /**
     * Initializes the value for the {@link Command#handlers() handlers} attribute.
     * @param handlers The value for handlers 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Command.Builder<H> handlers(H handlers) {
      this.handlers = Objects.requireNonNull(handlers, "handlers");
      initBits &= ~INIT_BIT_HANDLERS;
      return (Command.Builder<H>) this;
    }

    /**
     * Builds a new {@link Command Command}.
     * @return An immutable instance of Command
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Command<H> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableCommand.validate(new ImmutableCommand<H>(this));
    }

    private boolean callableIsSet() {
      return (optBits & OPT_BIT_CALLABLE) != 0;
    }

    private boolean aliasesIsSet() {
      return (optBits & OPT_BIT_ALIASES) != 0;
    }

    private boolean skipGroupCheckOnInteractionIsSet() {
      return (optBits & OPT_BIT_SKIP_GROUP_CHECK_ON_INTERACTION) != 0;
    }

    private boolean requireParentGroupsIsSet() {
      return (optBits & OPT_BIT_REQUIRE_PARENT_GROUPS) != 0;
    }

    private boolean nsfwIsSet() {
      return (optBits & OPT_BIT_NSFW) != 0;
    }

    private boolean repliesDefaultPrivateIsSet() {
      return (optBits & OPT_BIT_REPLIES_DEFAULT_PRIVATE) != 0;
    }

    private boolean deferReplyIsSet() {
      return (optBits & OPT_BIT_DEFER_REPLY) != 0;
    }

    private boolean inheritSettingsIsSet() {
      return (optBits & OPT_BIT_INHERIT_SETTINGS) != 0;
    }

    private boolean invokeParentIsSet() {
      return (optBits & OPT_BIT_INVOKE_PARENT) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_HANDLERS) != 0) attributes.add("handlers");
      return "Cannot build Command, some of required attributes are not set " + attributes;
    }
  }
}
