/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@FunctionalInterface
public interface TryParser<R, T>
extends ParserFunction<R, Result<R, T>> {
    @SideEffectFree
    public static <R, T> TryParser<R, T> of(ParserFunction<R, T> parser) {
        return () -> parser;
    }

    @SideEffectFree
    public static <R, T> List<T> items(List<Result<R, T>> results) {
        return results.stream().filter(i -> i instanceof Success).map(i -> (Success)i).map(i -> i.item()).toList();
    }

    @SideEffectFree
    public static <R, T> List<Failure<R, T>> errors(List<Result<R, T>> results) {
        return results.stream().filter(i -> i instanceof Failure).map(i -> (Failure)i).toList();
    }

    @SideEffectFree
    public static <R, T> Tuple2<List<T>, List<Failure<R, T>>> split(List<Result<R, T>> results) {
        return Tuples.of(TryParser.items(results), TryParser.errors(results));
    }

    @Pure
    public ParserFunction<R, T> parser();

    @Override
    default public Mono<Result<R, T>> parse(CommandContext context, R item) throws InvalidArgumentException {
        ParserFunction parser = this.parser();
        return Mono.defer(() -> parser.apply(context, item)).map(i -> new Success<Object, Object>(item, i)).onErrorResume(InvalidArgumentException.class, error -> Mono.just(new Failure(item, (InvalidArgumentException)error)));
    }

    public record Failure<R, T>(R raw, InvalidArgumentException error) implements Result<R, T>
    {
        @Override
        public @Nullable T item() {
            return null;
        }
    }

    public record Success<R, T>(R raw, T item) implements Result<R, T>
    {
        @Override
        public @Nullable InvalidArgumentException error() {
            return null;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Result<R, T> {
        @Pure
        public R raw();

        @Pure
        public @Nullable T item();

        @Pure
        public @Nullable InvalidArgumentException error();
    }
}

