/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.utils.OptionalUtils;
import dev.sympho.modular_commands.utils.parse.MentionableParser;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Role;
import reactor.core.publisher.Mono;

public class RoleParser
extends MentionableParser<Role> {
    @Override
    protected Mono<Role> getEntity(CommandContext context, Snowflake id) {
        return context.getGuild().flatMap(g -> g.getRoleById(id));
    }

    @Override
    public String parseMention(String mention) throws InvalidArgumentException {
        return OptionalUtils.castPresent(MentionableParser.parseMention(mention, "@&")).orElseThrow(() -> new InvalidArgumentException("Not a valid role mention: <%s>".formatted(mention)));
    }

    @Override
    public Mono<Role> parse(CommandContext context, String raw) throws InvalidArgumentException {
        if ("@everyone".equals(raw) || "@here".equals(raw)) {
            return context.getGuild().flatMap(Guild::getEveryoneRole);
        }
        return super.parse(context, raw);
    }
}

