/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.utils.parse.UrlParser;
import dev.sympho.modular_commands.utils.parse.UrlParserUtils;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import java.net.URL;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public abstract class EntityUrlParser<E extends @NonNull Entity>
implements UrlParser<E> {
    @Pure
    protected abstract boolean validPath(String var1);

    @SideEffectFree
    protected abstract @Nullable Mono<E> parsePath(GatewayDiscordClient var1, String var2);

    @Pure
    protected abstract String typeName();

    @Pure
    private boolean baseValid(URL url) {
        return UrlParserUtils.isHttps(url) && UrlParserUtils.isHost(url, "discord.com");
    }

    @Override
    public boolean supports(URL url) {
        return this.baseValid(url) && this.validPath(url.getPath());
    }

    @Override
    public Mono<E> parse(CommandContext context, URL url) throws InvalidArgumentException {
        if (!this.baseValid(url)) {
            throw new InvalidArgumentException("Not a valid Discord URL: %s".formatted(url));
        }
        Mono<E> res = this.parsePath(context.getClient(), url.getPath());
        if (res == null) {
            throw new InvalidArgumentException("Not a valid %s URL: %s".formatted(this.typeName(), url));
        }
        return res;
    }
}

