/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.ParserFunction;
import dev.sympho.modular_commands.utils.parse.EntityUrlParser;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Entity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public abstract class EntityParser<E extends @NonNull Entity>
implements ParserFunction<String, E> {
    @SideEffectFree
    public static Snowflake parseId(String raw) throws InvalidArgumentException {
        try {
            return Snowflake.of((String)raw);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(String.format("Value '%s' is not a valid snowflake ID.", raw));
        }
    }

    @Pure
    public @Nullable EntityUrlParser<E> getUrlParser() {
        return null;
    }

    @SideEffectFree
    public Snowflake extractId(String raw) throws InvalidArgumentException {
        return EntityParser.parseId(raw);
    }

    @SideEffectFree
    protected abstract Mono<E> getEntity(CommandContext var1, Snowflake var2);

    @Override
    public Mono<E> parse(CommandContext context, String raw) throws InvalidArgumentException {
        if (this.getUrlParser() != null && raw.startsWith("https://")) {
            return this.getUrlParser().parse(context, raw);
        }
        return this.getEntity(context, this.extractId(raw)).onErrorMap(e -> new InvalidArgumentException("Invalid.", (Throwable)e)).switchIfEmpty(Mono.error(() -> new InvalidArgumentException("Not found.")));
    }
}

