/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.parse;

import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.utils.parse.EntityUrlParser;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.channel.Channel;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;
import org.checkerframework.dataflow.qual.Pure;
import reactor.core.publisher.Mono;

public class ChannelUrlParser<C extends @NonNull Channel>
extends EntityUrlParser<C> {
    private static final Pattern PATH_PATTERN = Pattern.compile("/channels/\\d++/(\\d++)");
    private final Class<C> type;

    @Pure
    public ChannelUrlParser(Class<C> type) {
        this.type = Objects.requireNonNull(type);
    }

    @Pure
    public static <C extends Channel> C validate(Channel channel, Class<C> type) throws InvalidArgumentException {
        try {
            return (C)((Channel)type.cast(channel));
        }
        catch (ClassCastException e) {
            throw new InvalidArgumentException("Channel must be a %s".formatted(type.getSimpleName()));
        }
    }

    @Pure
    private C validate(Channel channel) throws InvalidArgumentException {
        return ChannelUrlParser.validate(channel, this.type);
    }

    @Override
    public String typeName() {
        return "channel";
    }

    @Override
    protected boolean validPath(String path) {
        return PATH_PATTERN.matcher(path).matches();
    }

    @Override
    protected @Nullable Mono<C> parsePath(GatewayDiscordClient client, String path) {
        Matcher match = PATH_PATTERN.matcher(path);
        if (!match.matches()) {
            return null;
        }
        String channelString = (String)NullnessUtil.castNonNull((Object)match.group(1));
        Snowflake channelId = Snowflake.of((String)channelString);
        return client.getChannelById(channelId).map(this::validate);
    }
}

