/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder;

import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import dev.sympho.modular_commands.utils.ParameterUtils;
import java.util.Objects;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ParameterBuilder<T> {
    protected @MonotonicNonNull @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name;
    protected @MonotonicNonNull @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description;
    protected boolean required;
    protected @Nullable T defaultValue;
    protected @MonotonicNonNull ArgumentParser<?, T> parser;

    @Pure
    public ParameterBuilder() {
        this.name = null;
        this.description = null;
        this.required = false;
        this.defaultValue = null;
        this.parser = null;
    }

    @SideEffectFree
    public ParameterBuilder(ParameterBuilder<T> base) {
        this.name = base.name;
        this.description = base.description;
        this.required = base.required;
        this.defaultValue = base.defaultValue;
        this.parser = base.parser;
    }

    @SideEffectFree
    public static <T> @CalledMethods(value={"withName", "withDescription", "withRequired", "withDefault", "withParser"}) ParameterBuilder<T> from(Parameter<T> base) throws IllegalArgumentException {
        return new ParameterBuilder<T>().withName(base.name()).withDescription(base.description()).withRequired(base.required()).withDefault(base.defaultValue()).withParser(base.parser());
    }

    @Deterministic
    public @This ParameterBuilder<T> withName(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) throws IllegalArgumentException {
        this.name = ParameterUtils.validateName(name);
        return this;
    }

    @Deterministic
    public @This ParameterBuilder<T> withDescription(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description) throws IllegalArgumentException {
        this.description = ParameterUtils.validateDescription(description);
        return this;
    }

    @Deterministic
    public @This ParameterBuilder<T> withRequired(boolean required) {
        this.required = required;
        return this;
    }

    @Deterministic
    public @This ParameterBuilder<T> withDefault(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Deterministic
    public @This ParameterBuilder<T> withParser(ArgumentParser<?, T> parser) {
        this.parser = Objects.requireNonNull(parser);
        return this;
    }

    @SideEffectFree
    public Parameter<T> build(@CalledMethods(value={"withName", "withDescription", "withParser"}) ParameterBuilder<T> this) throws IllegalStateException {
        if (this.name == null) {
            throw new IllegalStateException("Parameter name must be set before building.");
        }
        if (this.description == null) {
            throw new IllegalStateException("Parameter description must be set before building.");
        }
        if (this.parser == null) {
            throw new IllegalStateException("Parameter parser must be set before building.");
        }
        return new Parameter<T>(this.name, this.description, this.required, this.defaultValue, this.parser);
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof ParameterBuilder) {
            ParameterBuilder b = (ParameterBuilder)o;
            return Objects.equals(this.name, b.name) && Objects.equals(this.description, b.description) && this.required == b.required && Objects.equals(this.defaultValue, b.defaultValue) && Objects.equals(this.parser, b.parser);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.required, this.defaultValue, this.parser);
    }
}

