/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.ReplyManager;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.handler.InteractionHandlers;
import dev.sympho.modular_commands.api.command.handler.MessageHandlers;
import dev.sympho.modular_commands.api.command.handler.SlashHandlers;
import dev.sympho.modular_commands.api.command.handler.TextHandlers;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.api.permission.Groups;
import dev.sympho.modular_commands.impl.CommandImpl;
import dev.sympho.modular_commands.utils.CommandUtils;
import dev.sympho.modular_commands.utils.ParameterUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CommandBuilder<H extends Handlers> {
    public static final Command.Scope DEFAULT_SCOPE = Command.Scope.GLOBAL;
    public static final boolean DEFAULT_CALLABLE = true;
    public static final Group DEFAULT_GROUP = Groups.EVERYONE;
    public static final boolean DEFAULT_SKIP = true;
    public static final boolean DEFAULT_REQUIRE_PARENT_GROUPS = true;
    public static final boolean DEFAULT_NSFW = false;
    public static final boolean DEFAULT_PRIVATE = false;
    public static final ReplyManager.EphemeralType DEFAULT_EPHEMERAL = ReplyManager.EphemeralType.NONE;
    public static final boolean DEFAULT_INHERIT = false;
    public static final boolean DEFAULT_INVOKE_PARENT = false;
    protected Command.Scope scope;
    protected boolean callable;
    protected Invocation parent;
    protected @MonotonicNonNull @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name;
    protected Set<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> aliases;
    protected @MonotonicNonNull @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName;
    protected @MonotonicNonNull @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description;
    protected List<Parameter<?>> parameters;
    protected Group requiredGroup;
    protected boolean skipGroupCheckOnInteraction;
    protected boolean requireParentGroups;
    protected boolean nsfw;
    protected boolean privateReply;
    protected ReplyManager.EphemeralType ephemeralReply;
    protected boolean inheritSettings;
    protected boolean invokeParent;
    protected @MonotonicNonNull H handlers;

    @SideEffectFree
    public CommandBuilder() {
        this.scope = DEFAULT_SCOPE;
        this.callable = true;
        this.parent = Invocation.of(new String[0]);
        this.name = null;
        this.aliases = new HashSet<String>();
        this.displayName = null;
        this.parameters = new LinkedList();
        this.requiredGroup = DEFAULT_GROUP;
        this.skipGroupCheckOnInteraction = true;
        this.requireParentGroups = true;
        this.nsfw = false;
        this.privateReply = false;
        this.ephemeralReply = DEFAULT_EPHEMERAL;
        this.inheritSettings = false;
        this.invokeParent = false;
        this.handlers = null;
    }

    @SideEffectFree
    public CommandBuilder(CommandBuilder<? extends H> base) {
        this.scope = base.scope;
        this.callable = base.callable;
        this.parent = base.parent;
        this.name = base.name;
        this.aliases = new HashSet<String>(base.aliases);
        this.displayName = base.displayName;
        this.parameters = new LinkedList(base.parameters);
        this.requiredGroup = base.requiredGroup;
        this.skipGroupCheckOnInteraction = base.skipGroupCheckOnInteraction;
        this.requireParentGroups = base.requireParentGroups;
        this.nsfw = base.nsfw;
        this.privateReply = base.privateReply;
        this.ephemeralReply = base.ephemeralReply;
        this.inheritSettings = base.inheritSettings;
        this.invokeParent = base.invokeParent;
        this.handlers = base.handlers;
    }

    @SideEffectFree
    public static <H extends Handlers> @CalledMethods(value={"withScope", "withCallable", "withParent", "withName", "withAliases", "withDisplayName", "withDescription", "withParameters", "requireGroup", "setSkipGroupCheckOnInteraction", "setRequireParentGroups", "setNsfw", "setPrivateReply", "setEphemeralReply", "setInheritSettings", "setInvokeParent", "withHandlers"}) CommandBuilder<H> from(Command<H> base) throws IllegalArgumentException {
        return new CommandBuilder<H>().withScope(base.scope()).withCallable(base.callable()).withParent(base.parent()).withName(base.name()).withAliases(base.aliases()).withDisplayName(base.displayName()).withDescription(base.description()).withParameters(base.parameters()).requireGroup(base.requiredGroup()).setSkipGroupCheckOnInteraction(base.skipGroupCheckOnInteraction()).setRequireParentGroups(base.requireParentGroups()).setNsfw(base.nsfw()).setPrivateReply(base.privateReply()).setEphemeralReply(base.ephemeralReply()).setInheritSettings(base.inheritSettings()).setInvokeParent(base.invokeParent()).withHandlers(base.handlers());
    }

    public static CommandBuilder<MessageHandlers> message() {
        return new CommandBuilder<MessageHandlers>();
    }

    public static CommandBuilder<SlashHandlers> slash() {
        return new CommandBuilder<SlashHandlers>();
    }

    public static CommandBuilder<TextHandlers> text() {
        return new CommandBuilder<TextHandlers>();
    }

    public static CommandBuilder<InteractionHandlers> interaction() {
        return new CommandBuilder<InteractionHandlers>();
    }

    @Deterministic
    public @This CommandBuilder<H> withScope(@Nullable Command.Scope scope) {
        this.scope = Objects.requireNonNullElse(scope, DEFAULT_SCOPE);
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withCallable(boolean callable) {
        this.callable = callable;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withParent(@Nullable Invocation parent) {
        this.parent = CommandUtils.validateParent(Objects.requireNonNullElse(parent, Invocation.of(new String[0])));
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withName(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) {
        this.name = CommandUtils.validateName(name);
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withAliases(@Nullable Set<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> aliases) throws IllegalArgumentException {
        this.aliases = new HashSet<String>(CommandUtils.validateAliases(Objects.requireNonNullElse(aliases, Collections.emptySet())));
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> addAliases(String ... aliases) throws IllegalArgumentException {
        List<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> validated = Stream.of(aliases).map(CommandUtils::validateAlias).toList();
        this.aliases.addAll(validated);
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> noAliases() {
        this.aliases.clear();
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withDisplayName(@MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) {
        this.displayName = CommandUtils.validateDisplayName(name);
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withDescription(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description) {
        this.description = CommandUtils.validateDescription(description);
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withParameters(@Nullable List<Parameter<?>> parameters) {
        LinkedList params = new LinkedList(Objects.requireNonNullElse(parameters, Collections.emptyList()));
        params.forEach(Objects::requireNonNull);
        params.forEach(ParameterUtils::validate);
        this.parameters = params;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> addParameter(Parameter<?> parameter) {
        this.parameters.add(ParameterUtils.validate(Objects.requireNonNull(parameter, "Parameter cannot be null.")));
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> noParameters() {
        this.parameters.clear();
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> requireGroup(@Nullable Group group) {
        this.requiredGroup = Objects.requireNonNullElse(group, DEFAULT_GROUP);
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> setSkipGroupCheckOnInteraction(boolean skip) {
        this.skipGroupCheckOnInteraction = skip;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> setRequireParentGroups(boolean require) {
        this.requireParentGroups = require;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> setNsfw(boolean nsfw) {
        this.nsfw = nsfw;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> setPrivateReply(boolean privateReply) {
        this.privateReply = privateReply;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> setEphemeralReply(@Nullable ReplyManager.EphemeralType ephemeralReply) {
        this.ephemeralReply = Objects.requireNonNullElse(ephemeralReply, DEFAULT_EPHEMERAL);
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> setInheritSettings(boolean inheritSettings) {
        this.inheritSettings = inheritSettings;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> setInvokeParent(boolean invokeParent) {
        this.invokeParent = invokeParent;
        return this;
    }

    @Deterministic
    public @This CommandBuilder<H> withHandlers(H handlers) {
        this.handlers = CommandUtils.validateHandlers(handlers);
        return this;
    }

    @SideEffectFree
    public Command<H> build(@CalledMethods(value={"withName", "withDisplayName", "withDescription", "withHandlers"}) CommandBuilder<H> this) throws IllegalStateException {
        if (this.name == null) {
            throw new IllegalStateException("Command name must be set before building.");
        }
        if (this.displayName == null) {
            throw new IllegalStateException("Command display name must be set before building.");
        }
        if (this.description == null) {
            throw new IllegalStateException("Command description must be set before building.");
        }
        if (this.handlers == null) {
            throw new IllegalStateException("Command handlers must be set before building.");
        }
        try {
            return new CommandImpl<H>(this.scope, this.callable, this.parent, this.name, this.aliases, this.displayName, this.description, this.parameters, this.requiredGroup, this.skipGroupCheckOnInteraction, this.requireParentGroups, this.nsfw, this.privateReply, this.ephemeralReply, this.inheritSettings, this.invokeParent, this.handlers);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid parameter configuration.", e);
        }
    }
}

