/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ReactiveLatch
implements Function<Object, Publisher<Void>> {
    private final Sinks.Empty<Void> sink;
    private final AtomicLong count;

    @SideEffectFree
    public ReactiveLatch(long needed) throws IllegalArgumentException {
        if (needed <= 0L) {
            throw new IllegalArgumentException("Latch must require a positive number.");
        }
        this.sink = Sinks.empty();
        this.count = new AtomicLong(needed);
    }

    @SideEffectFree
    public ReactiveLatch() {
        this(1L);
    }

    @Override
    @Pure
    public Publisher<Void> apply(Object ignored) {
        return this.await();
    }

    @Pure
    public Mono<Void> await() {
        return this.sink.asMono();
    }

    public void countDown() throws IllegalStateException {
        Sinks.EmitResult result;
        if (this.count.decrementAndGet() == 0L && (result = this.sink.tryEmitEmpty()).isFailure()) {
            throw new IllegalStateException("Releasing latch failed: " + result);
        }
    }

    public void fail(Throwable error) throws IllegalStateException {
        Sinks.EmitResult result;
        if (this.count.getAndSet(0L) > 0L && (result = this.sink.tryEmitError(error)).isFailure()) {
            throw new IllegalStateException("Issuing error on latch failed: " + result);
        }
    }
}

