/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.utils.ParameterUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CommandUtils {
    private static final Pattern NAME_PATTERN = Pattern.compile("(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$");
    private static final Pattern DISPLAY_NAME_PATTERN = Pattern.compile("(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(?Us)^.{1,100}+$");

    private CommandUtils() {
    }

    public static Invocation validateParent(Invocation parent) {
        Objects.requireNonNull(parent, "Parent cannot be null.");
        parent.chain().forEach(CommandUtils::validateName);
        return parent;
    }

    @Pure
    @StaticallyExecutable
    public static @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String validateName(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) throws IllegalArgumentException {
        Objects.requireNonNull(name, "Name cannot be null.");
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name.");
        }
        if (!name.equals(name.toLowerCase())) {
            throw new IllegalArgumentException("Name must be all lowercase.");
        }
        return name;
    }

    @Pure
    @StaticallyExecutable
    public static @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String validateDisplayName(@MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name) throws IllegalArgumentException {
        Objects.requireNonNull(name, "Display name cannot be null.");
        if (!DISPLAY_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid display name.");
        }
        return name;
    }

    @Pure
    @StaticallyExecutable
    public static @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String validateAlias(@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String alias) throws IllegalArgumentException {
        Objects.requireNonNull(alias, "Alias cannot be null.");
        if (!NAME_PATTERN.matcher(alias).matches()) {
            throw new IllegalArgumentException("Invalid alias.");
        }
        return alias;
    }

    @SideEffectFree
    public static Set<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> validateAliases(Set<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> aliases) throws IllegalArgumentException {
        return Objects.requireNonNull(aliases, "Alias set cannot be null.").stream().map(CommandUtils::validateAlias).collect(Collectors.toUnmodifiableSet());
    }

    @Pure
    @StaticallyExecutable
    public static @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String validateDescription(@MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description) throws IllegalArgumentException {
        Objects.requireNonNull(description, "Description cannot be null.");
        if (!DESCRIPTION_PATTERN.matcher(description).matches()) {
            throw new IllegalArgumentException("Invalid description.");
        }
        return description;
    }

    @SideEffectFree
    public static List<Parameter<?>> validateParameters(List<Parameter<?>> parameters) throws IllegalArgumentException {
        Objects.requireNonNull(parameters, "Parameter list cannot be null.");
        boolean optional = false;
        for (Parameter<?> p : parameters) {
            Objects.requireNonNull(p, "Parameter specification cannot be null.");
            ParameterUtils.validate(p);
            if (!p.required()) {
                optional = true;
                continue;
            }
            if (!optional) continue;
            throw new IllegalArgumentException("Required parameters must be before optional parameters.");
        }
        Stream<String> nameStream = parameters.stream().map(Parameter::name);
        ImmutableMultiset names = ImmutableMultiset.copyOf(nameStream.iterator());
        for (Multiset.Entry entry : names.entrySet()) {
            if (entry.getCount() <= 1) continue;
            throw new IllegalArgumentException(String.format("Duplicate parameter: %s", entry.getElement()));
        }
        return List.copyOf(parameters);
    }

    @Pure
    public static Group validateGroup(Group group) {
        return Objects.requireNonNull(group, "Required group cannot be null.");
    }

    @Pure
    public static <H extends InvocationHandler<?>> H validateInvocationHandler(H handler) {
        return Objects.requireNonNull(handler, "Invocation handler cannot be null.");
    }

    @SideEffectFree
    public static <H extends ResultHandler<?>> List<H> validateResultHandlers(List<? extends H> handlers) {
        return Objects.requireNonNull(handlers, "Result handler list cannot be null.").stream().map(h -> Objects.requireNonNull(h, "Result handler cannot be null.")).collect(Collectors.toUnmodifiableList());
    }

    public static <H extends Handlers> H validateHandlers(H handlers) {
        CommandUtils.validateInvocationHandler(handlers.invocation());
        CommandUtils.validateResultHandlers(handlers.result());
        return handlers;
    }

    @Pure
    public static <C extends Command<?>> C validateCommand(C command) throws IllegalArgumentException {
        CommandUtils.validateName(command.name());
        CommandUtils.validateAliases(command.aliases());
        CommandUtils.validateDisplayName(command.displayName());
        CommandUtils.validateDescription(command.description());
        CommandUtils.validateParameters(command.parameters());
        CommandUtils.validateGroup(command.requiredGroup());
        CommandUtils.validateHandlers(command.handlers());
        return command;
    }
}

