/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.registry;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.handler.MessageHandlers;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.execute.InvocationUtils;
import dev.sympho.modular_commands.utils.CommandUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SimpleRegistry
implements Registry {
    private final Map<String, Command<?>> commands = new ConcurrentHashMap();
    private final Map<Invocation, Command<?>> invocations = new ConcurrentHashMap();
    private final Map<Invocation, Command<?>> aliasInvocations = new ConcurrentHashMap();

    @Override
    public <H extends Handlers> @Nullable Command<? extends H> findCommand(Invocation invocation, Class<H> type) {
        Command<?> found = this.invocations.get(invocation);
        if (found == null) {
            found = this.aliasInvocations.get(invocation);
        }
        return found == null ? null : InvocationUtils.checkType(found, type);
    }

    @Override
    public <H extends Handlers> Collection<Command<? extends H>> getCommands(Class<H> type) {
        return this.commands.values().stream().map(c -> InvocationUtils.checkType(c, type)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public @Nullable Command<?> getCommand(String id) {
        return this.commands.get(id);
    }

    @Override
    public synchronized boolean registerCommand(String id, Command<?> command) throws IllegalArgumentException {
        Set<Object> aliases;
        CommandUtils.validateCommand(command);
        Invocation invocation = command.invocation();
        Set<Object> set = aliases = command.handlers() instanceof MessageHandlers ? command.aliasInvocations() : Collections.emptySet();
        if (this.invocations.containsKey(invocation) || !Collections.disjoint(aliases, this.aliasInvocations.keySet())) {
            return false;
        }
        this.commands.put(id, command);
        this.invocations.put(invocation, command);
        for (Invocation invocation2 : aliases) {
            this.aliasInvocations.put(invocation2, command);
        }
        return true;
    }

    @Override
    public synchronized @Nullable Command<?> removeCommand(String id) {
        Command<?> command = this.commands.remove(id);
        if (command == null) {
            return null;
        }
        this.invocations.remove(command.invocation());
        if (command.handlers() instanceof MessageHandlers) {
            command.aliasInvocations().stream().forEach(this.aliasInvocations::remove);
        }
        return command;
    }
}

