/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import dev.sympho.modular_commands.api.command.ReplyManager;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.entity.channel.PrivateChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.MessageEditSpec;
import discord4j.rest.util.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class MessageReplyManager
implements ReplyManager {
    private static final int INITIAL_CAPACITY = 5;
    private final Message original;
    private final MessageChannel publicChannel;
    private final @MonotonicNonNull PrivateChannel privateChannel;
    private final List<Reply> replies;
    private Snowflake lastPublic;
    private @MonotonicNonNull Snowflake lastPrivate;
    private boolean priv;
    private ReplyManager.EphemeralType ephemeral;
    private Duration delay;
    private boolean deferred;

    @SideEffectFree
    public MessageReplyManager(Message original, MessageChannel publicChannel, PrivateChannel privateChannel) {
        this.original = Objects.requireNonNull(original);
        this.publicChannel = Objects.requireNonNull(publicChannel);
        this.privateChannel = publicChannel.getId().equals((Object)Objects.requireNonNull(privateChannel).getId()) ? null : privateChannel;
        this.replies = new ArrayList<Reply>(5);
        this.lastPublic = original.getId();
        this.lastPrivate = null;
        this.priv = false;
        this.ephemeral = ReplyManager.EphemeralType.NONE;
        this.delay = Duration.ZERO;
        this.deferred = false;
    }

    @Pure
    private MessageChannel getChannel(boolean sendPrivate) {
        if (sendPrivate && this.privateChannel != null) {
            return this.privateChannel;
        }
        return this.publicChannel;
    }

    private String getOriginalUrl() {
        String guild = this.original.getGuildId().map(Snowflake::asString).orElse("@me");
        String channel = this.publicChannel.getId().asString();
        String message = this.original.getId().asString();
        return "https://discord.com/channels/%s/%s/%s".formatted(guild, channel, message);
    }

    private Mono<Tuple2<Message, Integer>> sendReply(MessageCreateSpec spec, boolean sendPrivate, ReplyManager.EphemeralType sendEphemeral) {
        Mono prevId;
        Snowflake previous;
        MessageChannel channel = this.getChannel(sendPrivate);
        Snowflake snowflake = previous = sendPrivate ? this.lastPrivate : this.lastPublic;
        if (previous == null) {
            EmbedCreateSpec reference = EmbedCreateSpec.builder().color(Color.WHITE).addField("command", this.original.getContent(), false).addField("source", this.getOriginalUrl(), false).build();
            prevId = channel.createMessage(new EmbedCreateSpec[]{reference}).map(Message::getId);
        } else {
            prevId = Mono.just((Object)previous);
        }
        return prevId.map(id -> MessageCreateSpec.builder().from(spec).messageReference(id).build()).flatMap(arg_0 -> ((MessageChannel)channel).createMessage(arg_0)).map(m -> {
            int id = this.replies.size();
            this.replies.add(new Reply(channel, m.getId()));
            if (sendPrivate) {
                this.lastPrivate = m.getId();
            } else {
                this.lastPublic = m.getId();
            }
            if (sendEphemeral.timed()) {
                m.delete().delaySubscription(this.delay).subscribe();
            }
            return Tuples.of((Object)m, (Object)id);
        });
    }

    @Override
    public ReplyManager setPrivate(boolean priv) {
        if (this.privateChannel != null) {
            this.priv = priv;
        }
        return this;
    }

    @Override
    public ReplyManager setEphemeral(ReplyManager.EphemeralType ephemeral) {
        this.ephemeral = Objects.requireNonNull(ephemeral);
        return this;
    }

    @Override
    public ReplyManager setDeleteDelay(Duration delay) {
        this.delay = Objects.requireNonNull(delay);
        return this;
    }

    @Override
    public Mono<Void> defer() {
        if (this.deferred) {
            return Mono.empty();
        }
        this.deferred = true;
        return this.getChannel(this.priv).type();
    }

    @Override
    public Mono<Void> reply(MessageCreateSpec spec) throws IllegalStateException {
        if (!this.replies.isEmpty()) {
            throw new IllegalStateException("Reply already sent.");
        }
        return this.add(spec).then();
    }

    @Override
    public Mono<Tuple2<Message, Integer>> add(MessageCreateSpec spec) {
        boolean sendPrivate = this.priv;
        ReplyManager.EphemeralType sendEphemeral = this.ephemeral;
        return Mono.defer(() -> this.sendReply(spec, sendPrivate, sendEphemeral));
    }

    @Override
    public Mono<Message> edit(int index, MessageEditSpec spec) throws IndexOutOfBoundsException, IllegalStateException {
        return this.get(index).flatMap(m -> m.edit(spec));
    }

    @Override
    public Mono<Message> get(int index) throws IndexOutOfBoundsException, IllegalStateException {
        return this.replies.get(index).message();
    }

    @Override
    public Mono<Void> delete(int index) throws IndexOutOfBoundsException, IllegalStateException {
        return this.get(index).flatMap(Message::delete);
    }

    @Override
    public ReplyManager longTerm() {
        return this;
    }

    private record Reply(MessageChannel channel, Snowflake id) {
        public Mono<Message> message() {
            return this.channel.getMessageById(this.id);
        }
    }
}

