/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.ReplyManager;
import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.parameter.parse.ArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.BooleanParser;
import dev.sympho.modular_commands.api.command.parameter.parse.ChannelArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.FloatParser;
import dev.sympho.modular_commands.api.command.parameter.parse.IntegerParser;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.api.command.parameter.parse.MessageArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.RoleArgumentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.SnowflakeParser;
import dev.sympho.modular_commands.api.command.parameter.parse.StringParser;
import dev.sympho.modular_commands.api.command.parameter.parse.UserArgumentParser;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentInvalid;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentMissing;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.exception.ResultException;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.api.permission.Group;
import dev.sympho.modular_commands.execute.LazyContext;
import dev.sympho.modular_commands.utils.ReactiveLatch;
import dev.sympho.modular_commands.utils.parse.ParseUtils;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.MessageEditSpec;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethods;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

abstract class ContextImpl<A>
implements LazyContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextImpl.class);
    protected final List<Parameter<?>> parameters;
    private final Invocation invocation;
    private final AccessValidator access;
    private final Map<String, @Nullable Object> context;
    private @MonotonicNonNull Map<String, ? extends Argument<?>> arguments;
    private @MonotonicNonNull ReplyManager reply;
    private final AtomicBoolean initialized;
    private final ReactiveLatch initializeLatch;
    private @MonotonicNonNull Mono<CommandResult> loadResult;

    protected ContextImpl(Invocation invocation, List<Parameter<?>> parameters, AccessValidator access) {
        this.parameters = List.copyOf(parameters);
        this.invocation = invocation;
        this.access = access;
        this.context = new HashMap<String, Object>();
        this.arguments = null;
        this.reply = null;
        this.initialized = new AtomicBoolean(false);
        this.initializeLatch = new ReactiveLatch();
        this.loadResult = null;
    }

    protected abstract Mono<ReplyManager> makeReplyManager();

    @SideEffectFree
    protected abstract Mono<String> getStringArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Boolean> getBooleanArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Long> getIntegerArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Double> getFloatArgument(String var1) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<Snowflake> getSnowflakeArgument(String var1, SnowflakeParser.Type var2) throws InvalidArgumentException;

    @SideEffectFree
    protected abstract Mono<User> getUserArgument(String var1);

    @SideEffectFree
    protected abstract Mono<Role> getRoleArgument(String var1);

    @SideEffectFree
    protected abstract <C extends Channel> Mono<C> getChannelArgument(String var1, Class<C> var2);

    @SideEffectFree
    protected Mono<Message> getMessageArgument(String name) {
        return this.getStringArgument(name).flatMap(raw -> ParseUtils.MESSAGE.parse((CommandContext)this, (String)raw));
    }

    @SideEffectFree
    protected abstract Mono<Attachment> getAttachmentArgument(String var1);

    @SideEffectFree
    private <R, T> Mono<T> parseArgument(Parameter<T> parameter, Function<String, Mono<R>> getter, ArgumentParser<R, T> parser) throws InvalidArgumentException {
        return getter.apply(parameter.name()).flatMap(raw -> parser.parse(this, raw));
    }

    private <C extends Channel, T> Mono<T> parseArgument(Parameter<T> parameter, ChannelArgumentParser<C, T> parser) throws InvalidArgumentException {
        return this.parseArgument(parameter, name -> this.getChannelArgument((String)name, parser.type()), parser);
    }

    @SideEffectFree
    private <T> Mono<T> parseArgument(Parameter<T> parameter) {
        ArgumentParser<?, T> parser = parameter.parser();
        if (parser instanceof AttachmentParser) {
            AttachmentParser p = (AttachmentParser)parser;
            return this.parseArgument(parameter, this::getAttachmentArgument, p);
        }
        if (parser instanceof StringParser) {
            StringParser p = (StringParser)parser;
            return this.parseArgument(parameter, this::getStringArgument, p);
        }
        if (parser instanceof BooleanParser) {
            BooleanParser p = (BooleanParser)parser;
            return this.parseArgument(parameter, this::getBooleanArgument, p);
        }
        if (parser instanceof IntegerParser) {
            IntegerParser p = (IntegerParser)parser;
            return this.parseArgument(parameter, this::getIntegerArgument, p);
        }
        if (parser instanceof FloatParser) {
            FloatParser p = (FloatParser)parser;
            return this.parseArgument(parameter, this::getFloatArgument, p);
        }
        if (parser instanceof SnowflakeParser) {
            SnowflakeParser p = (SnowflakeParser)parser;
            return this.parseArgument(parameter, n -> this.getSnowflakeArgument((String)n, p.type()), p);
        }
        if (parser instanceof UserArgumentParser) {
            UserArgumentParser p = (UserArgumentParser)parser;
            return this.parseArgument(parameter, this::getUserArgument, p);
        }
        if (parser instanceof RoleArgumentParser) {
            RoleArgumentParser p = (RoleArgumentParser)parser;
            return this.parseArgument(parameter, this::getRoleArgument, p);
        }
        if (parser instanceof ChannelArgumentParser) {
            ChannelArgumentParser p = (ChannelArgumentParser)parser;
            return this.parseArgument(parameter, p);
        }
        if (parser instanceof MessageArgumentParser) {
            MessageArgumentParser p = (MessageArgumentParser)parser;
            return this.parseArgument(parameter, this::getMessageArgument, p);
        }
        throw new IllegalArgumentException("Unrecognized parser type: " + parser.getClass());
    }

    @SideEffectFree
    private ResultException wrapInvalidParam(Parameter<?> parameter, InvalidArgumentException exception) {
        LOGGER.trace("Invalid argument for parameter {}: {}", parameter, (Object)exception.getMessage());
        String error = exception.getMessage();
        CommandFailureArgumentInvalid result = new CommandFailureArgumentInvalid(parameter, error);
        return new ResultException(result);
    }

    @SideEffectFree
    private <T> Mono<T> handleMissingArgument(Parameter<T> parameter) {
        if (parameter.required()) {
            CommandFailureArgumentMissing result = new CommandFailureArgumentMissing(parameter);
            return Mono.error((Throwable)new ResultException(result));
        }
        T def = parameter.defaultValue();
        return def == null ? Mono.empty() : Mono.just(def);
    }

    @SideEffectFree
    private <T> Mono<? extends Argument<T>> parseArgumentWrapped(Parameter<T> parameter) {
        try {
            Class<InvalidArgumentException> ex = InvalidArgumentException.class;
            return this.parseArgument(parameter).onErrorMap(ex, e -> this.wrapInvalidParam(parameter, (InvalidArgumentException)e)).switchIfEmpty(Mono.defer(() -> this.handleMissingArgument(parameter))).map(v -> new Argument<Object>(parameter, v)).switchIfEmpty(Mono.fromSupplier(() -> new Argument<Object>(parameter, null)));
        }
        catch (InvalidArgumentException e2) {
            return Mono.error((Throwable)this.wrapInvalidParam(parameter, e2));
        }
    }

    @SideEffectFree
    private Mono<? extends Map.Entry<String, ? extends Argument<?>>> processArgument(Parameter<?> parameter) {
        return this.parseArgumentWrapped(parameter).map(a -> Map.entry(parameter.name(), a)).doOnError(t -> {
            if (t instanceof ResultException) {
                ResultException ex = (ResultException)t;
                LOGGER.trace("Arg processing aborted: {}", (Object)ex.getResult());
            } else {
                LOGGER.error("Failed to process argument", t);
            }
        });
    }

    protected abstract Mono<Void> initArgs();

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Pure
    private Argument<?> getArgument(String name) throws IllegalStateException, IllegalArgumentException {
        if (this.arguments == null) {
            throw new IllegalStateException("Context not loaded yet");
        }
        Argument<?> arg = this.arguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException(String.format("No parameter named '%s'", name));
        }
        return arg;
    }

    @Override
    public <T> @Nullable T getArgument(String name, Class<T> argumentType) throws IllegalArgumentException, ClassCastException {
        return this.getArgument(name).getValue(argumentType);
    }

    @Override
    public <T> @Nullable T getArgument(@FindDistinct Parameter<? extends T> parameter) throws IllegalArgumentException {
        Argument<?> argument = this.getArgument(parameter.name());
        if (argument.parameter() == parameter) {
            Argument<?> arg = argument;
            return (T)arg.value();
        }
        throw new IllegalArgumentException("Parameter does not match definition: " + parameter);
    }

    @Override
    public boolean setContext(String key, @Nullable Object obj, boolean replace) {
        if (!replace && this.context.containsKey(key)) {
            return false;
        }
        this.context.put(key, obj);
        return true;
    }

    @Override
    public <T> @Nullable T getContext(String key, Class<? extends T> type) throws IllegalArgumentException, ClassCastException {
        if (!this.context.containsKey(key)) {
            throw new IllegalArgumentException(String.format("No context under key '%s'.", key));
        }
        return type.cast(this.context.get(key));
    }

    @Override
    @Pure
    public ReplyManager replyManager() throws IllegalStateException {
        if (this.reply == null) {
            throw new IllegalStateException();
        }
        return this.reply;
    }

    @Override
    public final Mono<Boolean> hasAccess(Group group) {
        return this.access.hasAccess(group);
    }

    @Override
    public final Mono<CommandResult> validate(Group group) {
        return this.access.validate(group);
    }

    @Override
    public Mono<Void> initialize() {
        if (this.initialized.getAndSet(true)) {
            return this.initializeLatch.await();
        }
        LOGGER.trace("Initializing context");
        this.loadResult = Mono.defer(this::doLoad).cache();
        return this.makeReplyManager().map(ReplyManagerWrapper::new).doOnNext(manager -> {
            this.reply = manager;
        }).then().doOnSuccess(v -> this.initializeLatch.countDown()).doOnError(this.initializeLatch::fail).doOnSuccess(v -> LOGGER.trace("Context initialized")).doOnError(t -> LOGGER.error("Failed to initialize", t)).cache();
    }

    @EnsuresCalledMethods(value={"this"}, methods={"initArgs"})
    public Mono<CommandResult> doLoad() {
        LOGGER.trace("Loading context");
        return this.initArgs().thenMany((Publisher)Flux.fromIterable(this.parameters)).flatMap(this::processArgument).collectMap(Map.Entry::getKey, Map.Entry::getValue).doOnNext(args -> {
            this.arguments = args;
        }).name("parameter-parse").metrics().doOnSuccess(v -> LOGGER.trace("Context loaded")).doOnError(t -> {
            if (t instanceof ResultException) {
                ResultException ex = (ResultException)t;
                LOGGER.trace("Load aborted: {}", (Object)ex.getResult());
            } else {
                LOGGER.error("Failed to load", t);
            }
        }).then(Mono.empty().cast(CommandResult.class)).onErrorResume(ResultException.class, e -> Mono.just((Object)e.getResult()));
    }

    @Override
    public Mono<CommandResult> load() {
        if (this.loadResult == null) {
            throw new IllegalStateException("Called load() before initialize()");
        }
        return this.loadResult;
    }

    private record Argument<T>(Parameter<T> parameter, @Nullable T value) {
        public <E> @Nullable E getValue(Class<E> argumentType) throws ClassCastException {
            return argumentType.cast(this.value);
        }
    }

    private static final class ReplyManagerWrapper
    implements ReplyManager {
        private ReplyManager backing;

        ReplyManagerWrapper(ReplyManager backing) {
            this.backing = backing;
        }

        @Override
        public ReplyManager setPrivate(boolean priv) {
            return this.backing.setPrivate(priv);
        }

        @Override
        public ReplyManager setEphemeral(ReplyManager.EphemeralType ephemeral) {
            return this.backing.setEphemeral(ephemeral);
        }

        @Override
        public ReplyManager setDeleteDelay(Duration delay) {
            return this.backing.setDeleteDelay(delay);
        }

        @Override
        public Mono<Void> defer() {
            return this.backing.defer();
        }

        @Override
        public Mono<Void> reply(MessageCreateSpec spec) throws IllegalStateException {
            return this.backing.reply(spec);
        }

        @Override
        public Mono<Void> reply(String content) throws IllegalStateException {
            return this.backing.reply(content);
        }

        @Override
        public Mono<Void> reply(EmbedCreateSpec ... embeds) throws IllegalStateException {
            return this.backing.reply(embeds);
        }

        @Override
        public Mono<Tuple2<Message, Integer>> add(MessageCreateSpec spec) {
            return this.backing.add(spec);
        }

        @Override
        public Mono<Tuple2<Message, Integer>> add(String content) {
            return this.backing.add(content);
        }

        @Override
        public Mono<Tuple2<Message, Integer>> add(EmbedCreateSpec ... embeds) {
            return this.backing.add(embeds);
        }

        @Override
        public Mono<Message> edit(MessageEditSpec spec) throws IllegalStateException {
            return this.backing.edit(spec);
        }

        @Override
        public Mono<Message> edit(String content) throws IllegalStateException {
            return this.backing.edit(content);
        }

        @Override
        public Mono<Message> edit(EmbedCreateSpec ... embeds) throws IllegalStateException {
            return this.backing.edit(embeds);
        }

        @Override
        public Mono<Message> edit(int index, MessageEditSpec spec) throws IndexOutOfBoundsException {
            return this.backing.edit(index, spec);
        }

        @Override
        public Mono<Message> edit(int index, String content) throws IndexOutOfBoundsException {
            return this.backing.edit(index, content);
        }

        @Override
        public Mono<Message> edit(int index, EmbedCreateSpec ... embeds) throws IndexOutOfBoundsException {
            return this.backing.edit(index, embeds);
        }

        @Override
        public Mono<Message> get(int index) throws IndexOutOfBoundsException {
            return this.backing.get(index);
        }

        @Override
        public Mono<Message> get() throws IllegalStateException {
            return this.backing.get();
        }

        @Override
        public Mono<Void> delete(int index) throws IndexOutOfBoundsException {
            return this.backing.delete(index);
        }

        @Override
        public Mono<Void> delete() throws IllegalStateException {
            return this.backing.delete();
        }

        @Override
        public synchronized ReplyManager longTerm() {
            this.backing = this.backing.longTerm();
            return this;
        }
    }
}

