/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.result.CommandContinue;
import dev.sympho.modular_commands.api.command.result.CommandError;
import dev.sympho.modular_commands.api.command.result.CommandErrorException;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.Results;
import dev.sympho.modular_commands.api.exception.IncompleteHandlingException;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.execute.AccessManager;
import dev.sympho.modular_commands.execute.BaseHandler;
import dev.sympho.modular_commands.execute.InvocationUtils;
import dev.sympho.modular_commands.execute.InvocationValidator;
import dev.sympho.modular_commands.execute.LazyContext;
import dev.sympho.modular_commands.utils.SmartIterator;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import java.util.List;
import java.util.Optional;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

public abstract class PipelineBuilder<E extends Event, CTX extends CommandContext & LazyContext, H extends Handlers, I extends SmartIterator<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineBuilder.class);
    protected final AccessManager accessManager;

    protected PipelineBuilder(AccessManager accessManager) {
        this.accessManager = accessManager;
    }

    public Mono<Void> buildPipeline(GatewayDiscordClient client, Registry registry) {
        Flux source = client.on(this.eventType()).filter(this::eventFilter).doOnNext(e -> LOGGER.trace("Received event: {}", e));
        return this.buildPipeline(source, registry).retry();
    }

    @SideEffectFree
    private Mono<Void> buildPipeline(Flux<E> source, Registry registry) {
        return source.flatMap(event -> this.parseEvent(event, registry).flatMap(this::executeCommand).doOnNext(ctx -> {
            CommandContext context = (CommandContext)ctx.getT2();
            CommandResult result = (CommandResult)ctx.getT3();
            if (result instanceof CommandErrorException) {
                CommandErrorException r = (CommandErrorException)result;
                Throwable cause = r.cause();
                LOGGER.error(String.format("Exception while executing command %s", context.getInvocation()), cause);
            } else if (result instanceof CommandError) {
                CommandError r = (CommandError)result;
                LOGGER.error("Error while executing command {}: {}", (Object)context.getInvocation(), (Object)r.message());
            } else {
                LOGGER.debug("Finished command execution {} with result {}", (Object)context.getInvocation(), (Object)result.getClass().getSimpleName());
                LOGGER.trace("{} => {}", (Object)context.getInvocation(), (Object)result);
            }
        }).flatMap(this::handleResult).doOnNext(c -> LOGGER.warn("Handling of result of command {} not complete", (Object)c.getInvocation())).onErrorResume(e -> {
            LOGGER.error("Exception thrown within processing pipeline", e);
            return Mono.empty();
        })).doOnError(e -> LOGGER.error("Fatal error", e)).then();
    }

    @Pure
    protected abstract Class<E> eventType();

    @Pure
    protected abstract Class<H> commandType();

    @Pure
    protected abstract boolean fullMatch();

    @Pure
    protected boolean eventFilter(E event) {
        return true;
    }

    @Pure
    protected abstract InvocationValidator<E> getValidator();

    @SideEffectFree
    protected abstract I parse(E var1);

    @SideEffectFree
    protected abstract CTX makeContext(E var1, Command<? extends H> var2, Invocation var3, I var4);

    @SideEffectFree
    protected abstract Optional<Snowflake> getGuildId(E var1);

    @SideEffectFree
    protected abstract Mono<Guild> getGuild(E var1);

    @SideEffectFree
    protected abstract Mono<MessageChannel> getChannel(E var1);

    @SideEffectFree
    protected abstract User getCaller(E var1);

    @SideEffectFree
    protected AccessValidator accessValidator(E event) {
        Mono<Guild> guild = this.getGuild(event);
        Mono<MessageChannel> channel = this.getChannel(event);
        User caller = this.getCaller(event);
        return this.accessManager.validator(guild, channel, caller);
    }

    @Pure
    protected abstract InvocationHandler<? super CTX> getInvocationHandler(H var1);

    @Pure
    protected abstract List<? extends ResultHandler<? super CTX>> getResultHandlers(H var1);

    @Pure
    private boolean checkScope(Tuple4<E, List<Command<? extends H>>, Invocation, I> payload) {
        Event event = (Event)payload.getT1();
        List chain = (List)payload.getT2();
        Object command = InvocationUtils.getInvokedCommand(chain);
        return command.scope() == Command.Scope.GLOBAL || this.getGuildId(event).isPresent();
    }

    @Pure
    private boolean checkCallable(Tuple4<E, List<Command<? extends H>>, Invocation, I> payload) {
        List chain = (List)payload.getT2();
        Object command = InvocationUtils.getInvokedCommand(chain);
        return command.callable();
    }

    @SideEffectFree
    private Mono<Tuple4<E, List<Command<? extends H>>, Invocation, I>> parseEvent(E event, Registry registry) {
        return Mono.just(event).map(e -> Tuples.of((Object)e, this.parse(e))).filter(ctx -> ((SmartIterator)ctx.getT2()).hasNext()).map(ctx -> {
            Event e = (Event)ctx.getT1();
            SmartIterator args = (SmartIterator)ctx.getT2();
            LOGGER.trace("Parsed args {}", (Object)args);
            Tuple2<Invocation, List<Command<H>>> parsed = InvocationUtils.parseInvocation(registry, args, this.commandType());
            Invocation invocation = (Invocation)parsed.getT1();
            List chain = (List)parsed.getT2();
            if (this.fullMatch() && args.hasNext()) {
                throw new IllegalStateException("No full match found: " + args.toStream().toList().toString() + " was leftover after " + invocation.toString());
            }
            LOGGER.trace("Matched invocation {}", (Object)invocation);
            return Tuples.of((Object)e, (Object)chain, (Object)invocation, (Object)args);
        }).filter(ctx -> !((List)ctx.getT2()).isEmpty()).filter(this::checkScope).filter(this::checkCallable).name("command-parse").metrics();
    }

    @SideEffectFree
    private Mono<CommandResult> validateCommand(E event, List<? extends Command<? extends H>> chain) {
        InvocationValidator<E> validator = this.getValidator();
        AccessValidator access = this.accessValidator(event);
        return validator.validateSettings(event, chain).switchIfEmpty(validator.validateAccess(access, chain)).name("command-validate").metrics();
    }

    private boolean verifyHandled(CommandResult result, List<? extends Command<? extends H>> chain, CTX context) throws IncompleteHandlingException {
        if (result instanceof CommandContinue) {
            throw new IncompleteHandlingException(chain, context.getInvocation());
        }
        return true;
    }

    private Mono<CommandResult> invokeCommand(List<? extends Command<? extends H>> chain, CTX context) {
        Invocation invocation = InvocationUtils.getInvokedCommand(chain).invocation();
        LOGGER.debug("Invoking command {}", (Object)invocation);
        List handlers = InvocationUtils.accumulateHandlers(chain, this::getInvocationHandler);
        LOGGER.trace("Handlers for {}: {}", (Object)invocation, handlers);
        Mono state = Results.contMono();
        for (InvocationHandler handler : handlers) {
            state = state.flatMap(r -> {
                if (r instanceof CommandContinue) {
                    LOGGER.trace("Invoking command handler for {}", (Object)invocation);
                    return handler.handleWrapped(context);
                }
                LOGGER.trace("Skipping command handler for {}", (Object)invocation);
                return Mono.just((Object)r);
            });
        }
        return state.filter(r -> this.verifyHandled((CommandResult)r, chain, context)).name("command-invoke").metrics();
    }

    private <C extends Command<? extends H>> Mono<Tuple3<C, CTX, CommandResult>> executeCommand(Tuple4<E, List<C>, Invocation, I> payload) {
        Event event = (Event)payload.getT1();
        List chain = (List)payload.getT2();
        Invocation invocation = (Invocation)payload.getT3();
        SmartIterator args = (SmartIterator)payload.getT4();
        Object command = InvocationUtils.getInvokedCommand(chain);
        Object context = this.makeContext((E)event, (Command<? extends H>)command, invocation, (I)args);
        return ((LazyContext)context).initialize().then(this.validateCommand(event, chain)).switchIfEmpty(Mono.defer(() -> ((LazyContext)context).load())).switchIfEmpty(Mono.fromRunnable(() -> context.replyManager().setPrivate(command.privateReply()).setEphemeral(command.ephemeralReply()))).switchIfEmpty(Mono.defer(() -> this.invokeCommand(chain, context))).map(result -> Tuples.of((Object)command, (Object)context, (Object)result)).name("command-execute").metrics();
    }

    private Mono<CTX> handleResult(Tuple3<Command<? extends H>, CTX, CommandResult> payload) {
        Command command = (Command)payload.getT1();
        CommandContext context = (CommandContext)payload.getT2();
        CommandResult result = (CommandResult)payload.getT3();
        Mono state = Mono.just((Object)context);
        for (ResultHandler handler : this.getResultHandlers(command.handlers())) {
            state = state.filterWhen(c -> handler.handle(c, result));
        }
        state = state.filterWhen(c -> BaseHandler.get().handle((CommandContext)c, result));
        return state.name("command-result").metrics();
    }
}

