/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter.parse;

import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParser;
import dev.sympho.modular_commands.api.command.parameter.parse.AttachmentParserStages;
import dev.sympho.modular_commands.api.command.parameter.parse.InvalidArgumentException;
import dev.sympho.modular_commands.utils.SizeUtils;
import discord4j.core.object.entity.Attachment;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.dataflow.qual.Pure;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

@FunctionalInterface
public interface AttachmentDataParser<T>
extends AttachmentParser<T>,
AttachmentParserStages.Validator,
AttachmentParserStages.Parser<T> {
    @Override
    default public void validate(Attachment attachment) throws InvalidArgumentException {
    }

    @Pure
    default public @IntRange(from=0L) int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    default public Attachment validateRaw(Attachment raw) throws InvalidArgumentException {
        this.validate(AttachmentParser.super.validateRaw(raw));
        int size = raw.getSize();
        if (size > this.maxSize()) {
            String max = SizeUtils.format(this.maxSize());
            String got = SizeUtils.format(size);
            String message = "File must be at most %s (got %s)".formatted(max, got);
            throw new InvalidArgumentException(message);
        }
        return raw;
    }

    @Pure
    default public String getUrl(Attachment value) {
        return value.getUrl();
    }

    @Override
    default public Mono<T> parseArgument(CommandContext context, Attachment raw) throws InvalidArgumentException {
        return ((HttpClient.ResponseReceiver)HttpClient.create().get().uri(this.getUrl(raw))).responseSingle((response, body) -> this.parse(context, (HttpClientResponse)response, (ByteBufMono)body));
    }
}

