/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.context;

import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.ReplyManager;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.permission.AccessValidator;
import dev.sympho.modular_commands.api.permission.Group;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public interface CommandContext
extends AccessValidator {
    @Pure
    public Event getEvent();

    @Pure
    default public GatewayDiscordClient getClient() {
        return this.getEvent().getClient();
    }

    @Pure
    public Invocation getInvocation();

    @Pure
    public User getCaller();

    @Pure
    public @Nullable Member getCallerMember();

    public Mono<MessageChannel> getChannel();

    @Pure
    public Snowflake getChannelId();

    public Mono<Guild> getGuild();

    @Pure
    public @Nullable Snowflake getGuildId();

    @Pure
    public <T> @Nullable T getArgument(String var1, Class<T> var2) throws IllegalArgumentException, ClassCastException;

    @Pure
    default public <T> @Nullable T getArgument(Parameter<? extends T> parameter, Class<T> argumentType) throws IllegalArgumentException, ClassCastException {
        return this.getArgument(parameter.name(), argumentType);
    }

    @Pure
    public <T> @Nullable T getArgument(Parameter<? extends T> var1) throws IllegalArgumentException;

    @Pure
    default public <T> T requireArgument(String name, Class<T> argumentType) throws IllegalArgumentException, ClassCastException, NullPointerException {
        return Objects.requireNonNull(this.getArgument(name, argumentType));
    }

    @Pure
    default public <T> T requireArgument(Parameter<? extends T> parameter, Class<T> argumentType) throws IllegalArgumentException, ClassCastException, NullPointerException {
        return this.requireArgument(parameter.name(), argumentType);
    }

    @Pure
    default public <T> T requireArgument(Parameter<? extends T> parameter) throws IllegalArgumentException, NullPointerException {
        return Objects.requireNonNull(this.getArgument(parameter));
    }

    public boolean setContext(String var1, @Nullable Object var2, boolean var3);

    default public void setContext(String key, @Nullable Object obj) {
        this.setContext(key, obj, true);
    }

    @Pure
    public <T> @Nullable T getContext(String var1, Class<? extends T> var2) throws IllegalArgumentException, ClassCastException;

    @Pure
    default public <T> T requireContext(String key, Class<? extends T> type) throws IllegalArgumentException, ClassCastException, NullPointerException {
        return Objects.requireNonNull(this.getContext(key, type));
    }

    @SideEffectFree
    public ReplyManager replyManager();

    default public Mono<Void> deferReply() {
        return this.replyManager().defer();
    }

    default public Mono<Message> reply(String content) {
        return this.replyManager().add(content).map(Tuple2::getT1);
    }

    default public Mono<Message> reply(EmbedCreateSpec ... embeds) {
        return this.replyManager().add(embeds).map(Tuple2::getT1);
    }

    default public Mono<Message> reply(MessageCreateSpec spec) {
        return this.replyManager().add(spec).map(Tuple2::getT1);
    }

    @SideEffectFree
    default public Mono<Boolean> belongs(User user, Group group) {
        return group.belongs(this.getGuild(), this.getChannel(), user).defaultIfEmpty((Object)false);
    }

    @SideEffectFree
    default public Mono<Boolean> belongs(Snowflake user, Group group) {
        return this.getClient().getUserById(user).flatMap(u -> this.belongs((User)u, group));
    }
}

