/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command;

import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.MessageEditSpec;
import java.time.Duration;
import java.util.Arrays;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public interface ReplyManager {
    public static final String NO_RESPONSE_ERROR = "No response made yet.";

    public ReplyManager setPrivate(boolean var1);

    public ReplyManager setEphemeral(EphemeralType var1);

    public ReplyManager setDeleteDelay(Duration var1);

    public Mono<Void> defer();

    public Mono<Void> reply(MessageCreateSpec var1) throws IllegalStateException;

    default public Mono<Void> reply(String content) throws IllegalStateException {
        MessageCreateSpec spec = MessageCreateSpec.builder().content(content).build();
        return this.reply(spec);
    }

    default public Mono<Void> reply(EmbedCreateSpec ... embeds) throws IllegalStateException {
        MessageCreateSpec spec = MessageCreateSpec.builder().embeds(Arrays.asList(embeds)).build();
        return this.reply(spec);
    }

    public Mono<Tuple2<Message, Integer>> add(MessageCreateSpec var1);

    default public Mono<Tuple2<Message, Integer>> add(String content) {
        MessageCreateSpec spec = MessageCreateSpec.builder().content(content).build();
        return this.add(spec);
    }

    default public Mono<Tuple2<Message, Integer>> add(EmbedCreateSpec ... embeds) {
        MessageCreateSpec spec = MessageCreateSpec.builder().embeds(Arrays.asList(embeds)).build();
        return this.add(spec);
    }

    default public Mono<Message> edit(MessageEditSpec spec) throws IllegalStateException {
        try {
            return this.edit(0, spec);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(NO_RESPONSE_ERROR);
        }
    }

    default public Mono<Message> edit(String content) throws IllegalStateException {
        MessageEditSpec spec = MessageEditSpec.builder().contentOrNull(content).build();
        return this.edit(spec);
    }

    default public Mono<Message> edit(EmbedCreateSpec ... embeds) throws IllegalStateException {
        MessageEditSpec spec = MessageEditSpec.builder().embeds(Arrays.asList(embeds)).build();
        return this.edit(spec);
    }

    public Mono<Message> edit(int var1, MessageEditSpec var2) throws IndexOutOfBoundsException;

    default public Mono<Message> edit(int index, String content) throws IndexOutOfBoundsException {
        MessageEditSpec spec = MessageEditSpec.builder().contentOrNull(content).build();
        return this.edit(index, spec);
    }

    default public Mono<Message> edit(int index, EmbedCreateSpec ... embeds) throws IndexOutOfBoundsException {
        MessageEditSpec spec = MessageEditSpec.builder().embeds(Arrays.asList(embeds)).build();
        return this.edit(index, spec);
    }

    public Mono<Message> get(int var1) throws IndexOutOfBoundsException;

    default public Mono<Message> get() throws IllegalStateException {
        try {
            return this.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(NO_RESPONSE_ERROR);
        }
    }

    public Mono<Void> delete(int var1) throws IndexOutOfBoundsException;

    default public Mono<Void> delete() throws IllegalStateException {
        try {
            return this.delete(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(NO_RESPONSE_ERROR);
        }
    }

    public ReplyManager longTerm();

    public static enum EphemeralType {
        NONE,
        TIMED,
        INTERACTION,
        BOTH;


        public boolean timed() {
            return this == TIMED || this == BOTH;
        }

        public boolean interaction() {
            return this == INTERACTION || this == BOTH;
        }
    }
}

