/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.ListUtils;
import org.checkerframework.dataflow.qual.Pure;

public record Invocation(List<String> chain) {
    @Pure
    public Invocation(List<String> chain) {
        chain.forEach(c -> Objects.requireNonNull(c, "Invocation chain cannot contain null."));
        this.chain = List.copyOf(chain);
    }

    @Pure
    public Invocation child(String command) {
        List<String> childChain = List.of(Objects.requireNonNull(command, "Command cannot be null."));
        return new Invocation(ListUtils.union(this.chain, childChain));
    }

    @Pure
    public Invocation parent() {
        return new Invocation(this.chain.subList(0, this.chain.size() - 1));
    }

    @Pure
    public static Invocation of(String ... commands) {
        return new Invocation(Arrays.asList(commands));
    }
}

