/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command;

import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.ReplyManager;
import dev.sympho.modular_commands.api.command.handler.Handlers;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.permission.Group;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.common.value.qual.MatchesRegex;
import org.checkerframework.dataflow.qual.Pure;

public interface Command<H extends Handlers> {
    public static final @Regex String NAME_REGEX = "(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$";
    public static final @Regex String DISPLAY_NAME_REGEX = "(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$";
    public static final @Regex String DESCRIPTION_REGEX = "(?Us)^.{1,100}+$";

    @Pure
    public Scope scope();

    @Pure
    public boolean callable();

    @Pure
    public Invocation parent();

    @Pure
    public @MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String name();

    @Pure
    default public Invocation invocation() {
        return this.parent().child(this.name());
    }

    @Pure
    default public Set<@MatchesRegex(value={"(?U)^[-_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String> aliases() {
        return Collections.emptySet();
    }

    @Pure
    default public Set<Invocation> aliasInvocations() {
        return this.aliases().stream().map(this.parent()::child).collect(Collectors.toUnmodifiableSet());
    }

    @Pure
    public @MatchesRegex(value={"(?U)^[ -_\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}+$"}) String displayName();

    @Pure
    public @MatchesRegex(value={"(?Us)^.{1,100}+$"}) String description();

    @Pure
    public List<Parameter<?>> parameters();

    @Pure
    public Group requiredGroup();

    @Pure
    default public boolean skipGroupCheckOnInteraction() {
        return true;
    }

    @Pure
    public boolean requireParentGroups();

    @Pure
    public boolean nsfw();

    @Pure
    public boolean privateReply();

    @Pure
    public ReplyManager.EphemeralType ephemeralReply();

    @Pure
    public boolean inheritSettings();

    @Pure
    public boolean invokeParent();

    @Pure
    public H handlers();

    public static enum Scope {
        GLOBAL,
        GUILD;

    }
}

