/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api;

import dev.sympho.modular_commands.api.command.Command;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@FunctionalInterface
public interface CommandGroup {
    @Pure
    public Map<String, Command<?>> commands();

    @Pure
    default public Set<@KeyFor(value={"this.commands()"}) String> ids() {
        return this.commands().keySet();
    }

    @SideEffectFree
    public static CommandGroup of(Map<String, ? extends Command<?>> commands) {
        Map<String, ? extends Command<?>> copy = Map.copyOf(commands);
        return () -> copy;
    }

    @SideEffectFree
    public static CommandGroup merge(Collection<CommandGroup> groups) throws IllegalStateException {
        Map<String, Command> commands = groups.stream().map(CommandGroup::commands).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return CommandGroup.of(commands);
    }
}

