/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder.parameter;

import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.utils.ParameterUtils;
import dev.sympho.modular_commands.utils.builder.Builder;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ParameterBuilder<T, P extends @NonNull Parameter<T>, SELF extends @NonNull ParameterBuilder<T, P, SELF>>
implements Builder<SELF> {
    protected @MonotonicNonNull String name;
    protected @MonotonicNonNull String description;
    protected boolean required;
    protected @Nullable T defaultValue;

    @Pure
    protected ParameterBuilder() {
        this.name = null;
        this.description = null;
        this.required = false;
        this.defaultValue = null;
    }

    @SideEffectFree
    protected ParameterBuilder(ParameterBuilder<? extends T, ?, ?> base) {
        this.name = base.name;
        this.description = base.description;
        this.required = base.required;
        this.defaultValue = base.defaultValue;
    }

    @SideEffectFree
    protected ParameterBuilder(Parameter<T> base) {
        this.name = base.name();
        this.description = base.description();
        this.required = base.required();
        this.defaultValue = base.defaultValue();
    }

    @Deterministic
    public SELF withName(String name) throws IllegalArgumentException {
        this.name = ParameterUtils.validateName(name);
        return (SELF)((ParameterBuilder)this.self());
    }

    @Deterministic
    public SELF withDescription(String description) throws IllegalArgumentException {
        this.description = ParameterUtils.validateDescription(description);
        return (SELF)((ParameterBuilder)this.self());
    }

    @Deterministic
    public SELF withRequired(boolean required) {
        this.required = required;
        return (SELF)((ParameterBuilder)this.self());
    }

    @Deterministic
    public SELF withDefault(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
        return (SELF)((ParameterBuilder)this.self());
    }

    protected String buildName() throws IllegalStateException {
        if (this.name == null) {
            throw new IllegalStateException("Parameter name must be set before building.");
        }
        return this.name;
    }

    protected String buildDescription() throws IllegalStateException {
        if (this.description == null) {
            throw new IllegalStateException("Parameter description must be set before building.");
        }
        return this.description;
    }

    @SideEffectFree
    public abstract P build() throws IllegalStateException;

    public boolean equals(@Nullable Object o) {
        if (o instanceof ParameterBuilder) {
            ParameterBuilder b = (ParameterBuilder)o;
            return Objects.equals(this.name, b.name) && Objects.equals(this.description, b.description) && this.required == b.required && Objects.equals(this.defaultValue, b.defaultValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.required, this.defaultValue);
    }
}

