/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder.parameter;

import dev.sympho.modular_commands.api.command.parameter.NumberParameter;
import dev.sympho.modular_commands.utils.builder.parameter.ChoicesParameterBuilder;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class NumberParameterBuilder<T extends @NonNull Number, P extends @NonNull NumberParameter<T>, SELF extends @NonNull NumberParameterBuilder<T, P, SELF>>
extends ChoicesParameterBuilder<T, P, SELF> {
    protected @Nullable T minimum;
    protected @Nullable T maximum;

    @Pure
    protected NumberParameterBuilder() {
        this.choices = null;
    }

    @SideEffectFree
    protected NumberParameterBuilder(NumberParameterBuilder<? extends T, ?, ?> base) {
        super(base);
        this.minimum = base.minimum;
        this.maximum = base.maximum;
    }

    @SideEffectFree
    protected NumberParameterBuilder(NumberParameter<T> base) {
        super(base);
        this.minimum = base.minimum();
        this.maximum = base.maximum();
    }

    @Deterministic
    public SELF withMinimum(@Nullable T minimum) {
        this.minimum = minimum;
        return (SELF)((NumberParameterBuilder)this.noChoices());
    }

    @Deterministic
    public SELF withMaximum(@Nullable T maximum) {
        this.maximum = maximum;
        return (SELF)((NumberParameterBuilder)this.noChoices());
    }

    @Deterministic
    public SELF withRange(@Nullable T minimum, @Nullable T maximum) {
        return ((NumberParameterBuilder)this.withMinimum(minimum)).withMaximum(maximum);
    }

    @Deterministic
    public SELF noMinimum() {
        this.minimum = null;
        return (SELF)((NumberParameterBuilder)this.self());
    }

    @Deterministic
    public SELF noMaximum() {
        this.maximum = null;
        return (SELF)((NumberParameterBuilder)this.self());
    }

    @Deterministic
    public SELF noRange() {
        return ((NumberParameterBuilder)this.noMinimum()).noMaximum();
    }

    @Override
    public SELF withChoices(@Nullable Map<String, ? extends T> choices) {
        return ((NumberParameterBuilder)super.withChoices(choices)).noRange();
    }

    @Override
    public SELF addChoice(String name, T choice) {
        return ((NumberParameterBuilder)super.addChoice(name, choice)).noRange();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o instanceof NumberParameterBuilder) {
            NumberParameterBuilder b = (NumberParameterBuilder)o;
            return super.equals(o) && Objects.equals(this.minimum, b.minimum) && Objects.equals(this.maximum, b.maximum);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hash(this.minimum, this.maximum);
    }
}

