/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder.parameter;

import dev.sympho.modular_commands.api.command.parameter.ChoicesParameter;
import dev.sympho.modular_commands.utils.builder.parameter.ParameterBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ChoicesParameterBuilder<T, P extends @NonNull ChoicesParameter<T>, SELF extends @NonNull ChoicesParameterBuilder<T, P, SELF>>
extends ParameterBuilder<T, P, SELF> {
    protected @Nullable Map<String, T> choices;

    @Pure
    protected ChoicesParameterBuilder() {
        this.choices = null;
    }

    @SideEffectFree
    protected ChoicesParameterBuilder(ChoicesParameterBuilder<? extends T, ?, ?> base) {
        super(base);
        this.choices = base.choices == null ? null : new HashMap<String, T>(base.choices);
    }

    @SideEffectFree
    protected ChoicesParameterBuilder(ChoicesParameter<T> base) {
        super(base);
        this.choices = base.choices().isEmpty() ? null : new HashMap<String, T>(base.choices());
    }

    @Deterministic
    public SELF withChoices(@Nullable Map<String, ? extends T> choices) {
        this.choices = choices == null ? null : new HashMap<String, T>(choices);
        return (SELF)((ChoicesParameterBuilder)this.self());
    }

    @Deterministic
    public SELF addChoice(String name, T value) {
        if (this.choices == null) {
            this.choices = new HashMap<String, T>();
        }
        this.choices.put(name, value);
        return (SELF)((ChoicesParameterBuilder)this.self());
    }

    @Deterministic
    public SELF clearChoices() {
        this.choices = new HashMap<String, T>();
        return (SELF)((ChoicesParameterBuilder)this.self());
    }

    @Deterministic
    public SELF noChoices() {
        this.choices = null;
        return (SELF)((ChoicesParameterBuilder)this.self());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o instanceof ChoicesParameterBuilder) {
            ChoicesParameterBuilder b = (ChoicesParameterBuilder)o;
            return super.equals(o) && Objects.equals(this.choices, b.choices);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.choices);
    }
}

