/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder.command;

import dev.sympho.modular_commands.api.command.TextCommand;
import dev.sympho.modular_commands.api.command.handler.AnyCommandHandler;
import dev.sympho.modular_commands.api.command.handler.AnyResultHandler;
import dev.sympho.modular_commands.impl.command.TextCommandImpl;
import dev.sympho.modular_commands.utils.CommandUtils;
import dev.sympho.modular_commands.utils.builder.command.CommandBuilder;
import dev.sympho.modular_commands.utils.builder.command.MessageCommandBuilderMethods;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class TextCommandBuilder
extends CommandBuilder<TextCommand, AnyCommandHandler, AnyResultHandler, TextCommandBuilder>
implements MessageCommandBuilderMethods<TextCommandBuilder> {
    protected Set<String> aliases;

    @SideEffectFree
    public TextCommandBuilder() {
        this.aliases = new HashSet<String>();
    }

    @SideEffectFree
    public TextCommandBuilder(TextCommandBuilder base) {
        super(base);
        this.aliases = new HashSet<String>(base.aliases);
    }

    @SideEffectFree
    public TextCommandBuilder(TextCommand base) throws IllegalArgumentException {
        super(base);
        this.aliases = new HashSet<String>(base.aliases());
    }

    @Override
    public TextCommandBuilder withAliases(@Nullable Set<String> aliases) throws IllegalArgumentException {
        this.aliases = new HashSet<String>(CommandUtils.validateAliases(Objects.requireNonNullElse(aliases, Collections.emptySet())));
        return (TextCommandBuilder)this.self();
    }

    @Override
    public TextCommandBuilder addAliases(String alias) throws IllegalArgumentException {
        this.aliases.add(CommandUtils.validateAlias(alias));
        return (TextCommandBuilder)this.self();
    }

    @Override
    public TextCommandBuilder noAliases() {
        this.aliases.clear();
        return (TextCommandBuilder)this.self();
    }

    @Override
    public TextCommand build() throws IllegalStateException {
        try {
            return new TextCommandImpl(this.scope, this.callable, this.parent, this.buildName(), this.buildDisplayName(), this.aliases, this.buildDescription(), this.parameters, this.requiredDiscordPermissions, this.requireParentPermissions, this.nsfw, this.botOwnerOnly, this.serverOwnerOnly, this.privateReply, this.inheritSettings, this.invokeParent, (AnyCommandHandler)this.buildInvocationHandler(), this.resultHandlers);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid parameter configuration.", e);
        }
    }
}

