/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder.command;

import dev.sympho.modular_commands.api.command.MessageCommand;
import dev.sympho.modular_commands.api.command.handler.MessageInvocationHandler;
import dev.sympho.modular_commands.api.command.handler.MessageResultHandler;
import dev.sympho.modular_commands.impl.command.MessageCommandImpl;
import dev.sympho.modular_commands.utils.CommandUtils;
import dev.sympho.modular_commands.utils.builder.command.CommandBuilder;
import dev.sympho.modular_commands.utils.builder.command.MessageCommandBuilderMethods;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class MessageCommandBuilder
extends CommandBuilder<MessageCommand, MessageInvocationHandler, MessageResultHandler, MessageCommandBuilder>
implements MessageCommandBuilderMethods<MessageCommandBuilder> {
    protected Set<String> aliases;

    @SideEffectFree
    public MessageCommandBuilder() {
        this.aliases = new HashSet<String>();
    }

    @SideEffectFree
    public MessageCommandBuilder(MessageCommandBuilder base) {
        super(base);
        this.aliases = new HashSet<String>(base.aliases);
    }

    @SideEffectFree
    public MessageCommandBuilder(MessageCommand base) throws IllegalArgumentException {
        super(base);
        this.aliases = new HashSet<String>(base.aliases());
    }

    @Override
    public MessageCommandBuilder withAliases(@Nullable Set<String> aliases) throws IllegalArgumentException {
        this.aliases = new HashSet<String>(CommandUtils.validateAliases(Objects.requireNonNullElse(aliases, Collections.emptySet())));
        return (MessageCommandBuilder)this.self();
    }

    @Override
    public MessageCommandBuilder addAliases(String alias) throws IllegalArgumentException {
        this.aliases.add(CommandUtils.validateAlias(alias));
        return (MessageCommandBuilder)this.self();
    }

    @Override
    public MessageCommandBuilder noAliases() {
        this.aliases.clear();
        return (MessageCommandBuilder)this.self();
    }

    @Override
    public MessageCommand build() throws IllegalStateException {
        try {
            return new MessageCommandImpl(this.scope, this.callable, this.parent, this.buildName(), this.buildDisplayName(), this.aliases, this.buildDescription(), this.parameters, this.requiredDiscordPermissions, this.requireParentPermissions, this.nsfw, this.botOwnerOnly, this.serverOwnerOnly, this.privateReply, this.inheritSettings, this.invokeParent, (MessageInvocationHandler)this.buildInvocationHandler(), this.resultHandlers);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid parameter configuration.", e);
        }
    }
}

