/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils.builder.command;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.utils.CommandUtils;
import dev.sympho.modular_commands.utils.builder.Builder;
import discord4j.rest.util.PermissionSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.SideEffectFree;

abstract class CommandBuilder<C extends @NonNull Command, IH extends @NonNull InvocationHandler, RH extends @NonNull ResultHandler, SELF extends @NonNull CommandBuilder<C, IH, RH, SELF>>
implements Builder<SELF> {
    protected Command.Scope scope;
    protected boolean callable;
    protected Invocation parent;
    protected @MonotonicNonNull String name;
    protected @MonotonicNonNull String displayName;
    protected @MonotonicNonNull String description;
    protected List<Parameter<?>> parameters;
    protected PermissionSet requiredDiscordPermissions;
    protected boolean requireParentPermissions;
    protected boolean nsfw;
    protected boolean botOwnerOnly;
    protected boolean serverOwnerOnly;
    protected boolean privateReply;
    protected boolean inheritSettings;
    protected boolean invokeParent;
    protected @MonotonicNonNull IH invocationHandler;
    protected List<RH> resultHandlers;

    @SideEffectFree
    protected CommandBuilder() {
        this.scope = Command.Scope.GLOBAL;
        this.callable = true;
        this.parent = Invocation.of(new String[0]);
        this.name = null;
        this.displayName = null;
        this.parameters = new LinkedList();
        this.requiredDiscordPermissions = PermissionSet.none();
        this.requireParentPermissions = true;
        this.nsfw = false;
        this.botOwnerOnly = false;
        this.serverOwnerOnly = false;
        this.privateReply = true;
        this.inheritSettings = false;
        this.invokeParent = false;
        this.invocationHandler = null;
        this.resultHandlers = new LinkedList<RH>();
    }

    @SideEffectFree
    protected CommandBuilder(CommandBuilder<?, ? extends IH, ? extends RH, ?> base) {
        this.scope = base.scope;
        this.callable = base.callable;
        this.parent = base.parent;
        this.name = base.name;
        this.displayName = base.displayName;
        this.parameters = new LinkedList(base.parameters);
        this.requiredDiscordPermissions = base.requiredDiscordPermissions;
        this.requireParentPermissions = base.requireParentPermissions;
        this.nsfw = base.nsfw;
        this.botOwnerOnly = base.botOwnerOnly;
        this.serverOwnerOnly = base.serverOwnerOnly;
        this.privateReply = base.privateReply;
        this.inheritSettings = base.inheritSettings;
        this.invokeParent = base.invokeParent;
        this.invocationHandler = base.invocationHandler;
        this.resultHandlers = new LinkedList<RH>(base.resultHandlers);
    }

    @SideEffectFree
    protected CommandBuilder(C base) throws IllegalArgumentException {
        CommandUtils.validateCommand(base);
        this.scope = base.scope();
        this.callable = base.callable();
        this.parent = base.parent();
        this.name = base.name();
        this.displayName = base.displayName();
        this.parameters = new LinkedList(base.parameters());
        this.requiredDiscordPermissions = base.requiredDiscordPermissions();
        this.requireParentPermissions = base.requireParentPermissions();
        this.nsfw = base.nsfw();
        this.botOwnerOnly = base.botOwnerOnly();
        this.serverOwnerOnly = base.serverOwnerOnly();
        this.privateReply = base.privateReply();
        this.inheritSettings = base.inheritSettings();
        this.invokeParent = base.invokeParent();
        this.invocationHandler = base.invocationHandler();
        this.resultHandlers = new LinkedList<ResultHandler>(base.resultHandlers());
    }

    @Deterministic
    public SELF withScope(@Nullable Command.Scope scope) {
        this.scope = Objects.requireNonNullElse(scope, Command.Scope.GLOBAL);
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withCallable(boolean callable) {
        this.callable = callable;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withParent(@Nullable Invocation parent) {
        this.parent = CommandUtils.validateParent(Objects.requireNonNullElse(parent, Invocation.of(new String[0])));
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withName(String name) {
        this.name = CommandUtils.validateName(name);
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withDisplayName(String name) {
        this.displayName = CommandUtils.validateDisplayName(name);
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withDescription(String description) {
        this.description = CommandUtils.validateDescription(description);
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withParameters(@Nullable List<Parameter<?>> parameters) throws IllegalArgumentException {
        this.parameters = new LinkedList(CommandUtils.validateParameters(Objects.requireNonNullElse(parameters, Collections.emptyList())));
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF addParameter(Parameter<?> parameter) {
        this.parameters.add(Objects.requireNonNull(parameter, "Parameter cannot be null."));
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF noParameters() {
        this.parameters.clear();
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF requireDiscordPermissions(@Nullable PermissionSet permissions) {
        this.requiredDiscordPermissions = Objects.requireNonNullElse(permissions, PermissionSet.none());
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF setRequireParentPermissions(boolean require) {
        this.requireParentPermissions = require;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF setNsfw(boolean nsfw) {
        this.nsfw = nsfw;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF setBotOwnerOnly(boolean botOwnerOnly) {
        this.botOwnerOnly = botOwnerOnly;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF setServerOwnerOnly(boolean serverOwnerOnly) {
        this.serverOwnerOnly = serverOwnerOnly;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF setPrivateReply(boolean privateReply) {
        this.privateReply = privateReply;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF setInheritSettings(boolean inheritSettings) {
        this.inheritSettings = inheritSettings;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF setInvokeParent(boolean invokeParent) {
        this.invokeParent = invokeParent;
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withInvocationHandler(IH handler) {
        this.invocationHandler = CommandUtils.validateInvocationHandler(handler);
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF withResultHandlers(List<? extends RH> handlers) {
        this.resultHandlers = new LinkedList(CommandUtils.validateResultHandlers(Objects.requireNonNullElse(handlers, Collections.emptyList())));
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF addResultHandler(RH handler) {
        Objects.requireNonNull(handler, "Result handler cannot be null.");
        this.resultHandlers.add(handler);
        return (SELF)((CommandBuilder)this.self());
    }

    @Deterministic
    public SELF noResultHandlers() {
        this.resultHandlers.clear();
        return (SELF)((CommandBuilder)this.self());
    }

    protected String buildName() throws IllegalStateException {
        if (this.name == null) {
            throw new IllegalStateException("Command name must be set before building.");
        }
        return this.name;
    }

    protected String buildDisplayName() throws IllegalStateException {
        if (this.displayName == null) {
            throw new IllegalStateException("Command display name must be set before building.");
        }
        return this.displayName;
    }

    protected String buildDescription() throws IllegalStateException {
        if (this.description == null) {
            throw new IllegalStateException("Command description must be set before building.");
        }
        return this.description;
    }

    protected IH buildInvocationHandler() throws IllegalStateException {
        if (this.invocationHandler == null) {
            throw new IllegalStateException("Command invocation handler must be set before building.");
        }
        return this.invocationHandler;
    }

    @SideEffectFree
    public abstract C build() throws IllegalStateException;
}

