/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import dev.sympho.modular_commands.utils.CommandUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ParameterUtils {
    private ParameterUtils() {
    }

    @Pure
    @StaticallyExecutable
    public static String validateName(String name) throws IllegalArgumentException {
        return CommandUtils.validateName(name);
    }

    @Pure
    @StaticallyExecutable
    public static String validateDescription(String description) throws IllegalArgumentException {
        return CommandUtils.validateDescription(description);
    }

    @SideEffectFree
    public static <T> Map<String, T> validateChoices(@Nullable Map<String, T> choices) throws IllegalArgumentException {
        if (choices == null) {
            return Collections.emptyMap();
        }
        if (choices.isEmpty()) {
            throw new IllegalArgumentException("Choices set cannot be empty.");
        }
        choices.entrySet().forEach(e -> {
            Objects.requireNonNull((String)e.getKey(), "One of the choice names was null.");
            Objects.requireNonNull(e.getValue(), "One of the choices was null.");
            if (((String)e.getKey()).isEmpty()) {
                throw new IllegalArgumentException("A choice name cannot be empty.");
            }
        });
        return Collections.unmodifiableMap(new HashMap<String, T>(choices));
    }
}

