/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.utils;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.MessageCommand;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Range;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.common.value.qual.StaticallyExecutable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CommandUtils {
    private static final @Regex String NAME_REGEX = "^[\\w-]{1,32}$";
    private static final Pattern NAME_PATTERN = Pattern.compile("^[\\w-]{1,32}$", 256);
    private static final @Regex String DISPLAY_NAME_REGEX = "^[\\w- ]{1,32}$";
    private static final Pattern DISPLAY_NAME_PATTERN = Pattern.compile("^[\\w- ]{1,32}$", 256);
    private static final Range<Integer> DESCRIPTION_RANGE = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100));

    private CommandUtils() {
    }

    public static Invocation validateParent(Invocation parent) {
        Objects.requireNonNull(parent, "Parent cannot be null.");
        parent.chain().forEach(CommandUtils::validateName);
        return parent;
    }

    @Pure
    @StaticallyExecutable
    public static String validateName(String name) throws IllegalArgumentException {
        Objects.requireNonNull(name, "Name cannot be null.");
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name.");
        }
        if (!name.equals(name.toLowerCase())) {
            throw new IllegalArgumentException("Name must be all lowercase.");
        }
        return name;
    }

    @Pure
    @StaticallyExecutable
    public static String validateDisplayName(String name) throws IllegalArgumentException {
        Objects.requireNonNull(name, "Display name cannot be null.");
        if (!DISPLAY_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid display name.");
        }
        return name;
    }

    @Pure
    @StaticallyExecutable
    public static String validateAlias(String alias) throws IllegalArgumentException {
        Objects.requireNonNull(alias, "Alias cannot be null.");
        if (!NAME_PATTERN.matcher(alias).matches()) {
            throw new IllegalArgumentException("Invalid alias.");
        }
        return alias;
    }

    @SideEffectFree
    public static Set<String> validateAliases(Set<String> aliases) throws IllegalArgumentException {
        return Objects.requireNonNull(aliases, "Alias set cannot be null.").stream().map(CommandUtils::validateAlias).collect(Collectors.toUnmodifiableSet());
    }

    @Pure
    @StaticallyExecutable
    public static String validateDescription(String description) throws IllegalArgumentException {
        Objects.requireNonNull(description, "Description cannot be null.");
        if (!DESCRIPTION_RANGE.contains((Object)description.length())) {
            throw new IllegalArgumentException("Description must be between 1 and 100 characters.");
        }
        return description;
    }

    @SideEffectFree
    public static List<Parameter<?>> validateParameters(List<Parameter<?>> parameters) throws IllegalArgumentException {
        Objects.requireNonNull(parameters, "Parameter list cannot be null.");
        boolean optional = false;
        for (Parameter<?> p : parameters) {
            Objects.requireNonNull(p, "Parameter specification cannot be null.");
            if (!p.required()) {
                optional = true;
                continue;
            }
            if (!optional) continue;
            throw new IllegalArgumentException("Required parameters must be before optional parameters.");
        }
        Stream<String> nameStream = parameters.stream().map(Parameter::name);
        ImmutableMultiset names = ImmutableMultiset.copyOf(nameStream.iterator());
        for (Multiset.Entry entry : names.entrySet()) {
            if (entry.getCount() <= 1) continue;
            throw new IllegalArgumentException(String.format("Duplicate argument: %s", entry.getElement()));
        }
        return Collections.unmodifiableList(new ArrayList(parameters));
    }

    @Pure
    public static PermissionSet validateDiscordPermissions(PermissionSet perms) {
        return Objects.requireNonNull(perms, "Discord permission set cannot be null.");
    }

    @Pure
    public static <H extends InvocationHandler> H validateInvocationHandler(H handler) {
        return Objects.requireNonNull(handler, "Invocation handler cannot be null.");
    }

    @SideEffectFree
    public static <H extends ResultHandler> List<H> validateResultHandlers(List<? extends H> handlers) {
        return Objects.requireNonNull(handlers, "Result handler list cannot be null.").stream().map(h -> Objects.requireNonNull(h, "Result handler cannot be null.")).collect(Collectors.toUnmodifiableList());
    }

    @Pure
    public static <C extends Command> C validateCommand(C command) throws IllegalArgumentException {
        CommandUtils.validateName(command.name());
        CommandUtils.validateDisplayName(command.displayName());
        CommandUtils.validateDescription(command.description());
        CommandUtils.validateParameters(command.parameters());
        CommandUtils.validateDiscordPermissions(command.requiredDiscordPermissions());
        CommandUtils.validateInvocationHandler(command.invocationHandler());
        CommandUtils.validateResultHandlers(command.resultHandlers());
        if (command instanceof MessageCommand) {
            MessageCommand c = (MessageCommand)command;
            CommandUtils.validateAliases(c.aliases());
        }
        return command;
    }
}

