/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.registry;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.MessageCommand;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.utils.CommandUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SimpleRegistry
implements Registry {
    private final Map<String, Command> commands = new ConcurrentHashMap<String, Command>();
    private final Map<Invocation, Command> invocations = new ConcurrentHashMap<Invocation, Command>();
    private final Map<Invocation, Command> aliasInvocations = new ConcurrentHashMap<Invocation, Command>();

    @Override
    public <C extends Command> @Nullable C findCommand(Invocation invocation, Class<? extends C> type) {
        Command found = this.invocations.get(invocation);
        if (found == null) {
            found = this.aliasInvocations.get(invocation);
        }
        return (C)(type.isInstance(found) ? (Command)type.cast(found) : null);
    }

    @Override
    public <C extends Command> Collection<C> getCommands(Class<? extends C> type) {
        return this.commands.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public @Nullable Command getCommand(String id) {
        return this.commands.get(id);
    }

    @Override
    public synchronized boolean registerCommand(String id, Command command) throws IllegalArgumentException {
        Set<Invocation> aliases;
        CommandUtils.validateCommand(command);
        Invocation invocation = command.invocation();
        if (command instanceof MessageCommand) {
            MessageCommand c = (MessageCommand)command;
            v0 = c.aliasInvocations();
        } else {
            v0 = aliases = Collections.emptySet();
        }
        if (this.invocations.containsKey(invocation) || !Collections.disjoint(aliases, this.aliasInvocations.keySet())) {
            return false;
        }
        this.commands.put(id, command);
        this.invocations.put(invocation, command);
        for (Invocation alias : aliases) {
            this.aliasInvocations.put(alias, command);
        }
        return true;
    }

    @Override
    public synchronized @Nullable Command removeCommand(String id) {
        Command command = this.commands.remove(id);
        if (command == null) {
            return null;
        }
        this.invocations.remove(command.invocation());
        if (command instanceof MessageCommand) {
            MessageCommand c = (MessageCommand)command;
            c.aliasInvocations().stream().forEach(this.aliasInvocations::remove);
        }
        return command;
    }
}

