/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.context.MessageCommandContext;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.parameter.StringParameter;
import dev.sympho.modular_commands.api.exception.InvalidArgumentException;
import dev.sympho.modular_commands.impl.context.ContextImpl;
import discord4j.common.util.Snowflake;
import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import reactor.core.publisher.Mono;

public final class MessageContextImpl
extends ContextImpl<String>
implements MessageCommandContext {
    private final MessageCreateEvent event;

    public MessageContextImpl(MessageCreateEvent event, Invocation invocation, List<Parameter<?>> parameters, List<String> args) {
        super(invocation, parameters, MessageContextImpl.adjustArgs(parameters, args));
        this.event = event;
    }

    private static List<String> adjustArgs(List<Parameter<?>> parameters, List<String> args) {
        if (args.size() <= parameters.size()) {
            return args;
        }
        int last = parameters.size() - 1;
        if (parameters.get(last) instanceof StringParameter) {
            List<String> head = args.subList(0, last);
            List<String> tail = args.subList(last, args.size());
            String expandedLast = String.join((CharSequence)" ", tail);
            return ListUtils.union(head, List.of(expandedLast));
        }
        return args;
    }

    @Override
    protected Mono<Object> parseArgument(Parameter<?> parameter, String raw) throws InvalidArgumentException {
        return parameter.parse(raw).map(a -> a);
    }

    @Override
    public User getCaller() {
        Optional author = this.event.getMessage().getAuthor();
        if (author.isPresent()) {
            return (User)author.get();
        }
        throw new IllegalStateException("Message with no author.");
    }

    @Override
    public @Nullable Member getCallerMember() {
        return null;
    }

    @Override
    public Mono<MessageChannel> getChannel() {
        return this.event.getMessage().getChannel();
    }

    @Override
    public Snowflake getChannelId() {
        return this.event.getMessage().getChannelId();
    }

    @Override
    public Mono<Guild> getGuild() {
        return this.event.getGuild();
    }

    @Override
    public @Nullable Snowflake getGuildId() {
        return this.event.getGuildId().orElse(null);
    }

    @Override
    public MessageCreateEvent getMessageEvent() {
        return this.event;
    }
}

