/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.impl.context;

import com.google.common.collect.Streams;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.context.LazyContext;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentExtra;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentInvalid;
import dev.sympho.modular_commands.api.command.result.CommandFailureArgumentMissing;
import dev.sympho.modular_commands.api.exception.InvalidArgumentException;
import dev.sympho.modular_commands.execute.ResultException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

abstract class ContextImpl<A>
implements LazyContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextImpl.class);
    private final List<Parameter<?>> parameterOrder;
    private final List<A> rawArguments;
    private final Map<String, Argument> arguments;
    private final Invocation invocation;
    private final Map<String, @Nullable Object> context;

    protected ContextImpl(Invocation invocation, List<Parameter<?>> parameters, List<A> rawArguments) {
        this.parameterOrder = parameters.stream().toList();
        this.rawArguments = rawArguments.stream().toList();
        this.invocation = invocation;
        this.arguments = parameters.stream().collect(Collectors.toUnmodifiableMap(Parameter::name, p -> new Argument()));
        this.context = new HashMap<String, Object>();
    }

    protected abstract Mono<Object> parseArgument(Parameter<?> var1, A var2) throws InvalidArgumentException;

    protected String rawToString(A raw) {
        return Objects.toString(raw);
    }

    private ResultException wrapInvalidParam(Parameter<?> parameter, A raw, InvalidArgumentException exception) {
        String arg = this.rawToString(raw);
        String error = exception.getMessage();
        CommandFailureArgumentInvalid result = new CommandFailureArgumentInvalid(arg, parameter, error);
        return new ResultException(result);
    }

    private Mono<Object> parseArgumentWrapped(Parameter<?> parameter, A raw) throws ResultException {
        try {
            return this.parseArgument(parameter, raw).onErrorMap(InvalidArgumentException.class, e -> this.wrapInvalidParam(parameter, raw, (InvalidArgumentException)e));
        }
        catch (InvalidArgumentException e2) {
            throw this.wrapInvalidParam(parameter, raw, e2);
        }
    }

    @Pure
    private static Optional<Object> missingArgument(Parameter<?> parameter) throws ResultException {
        if (parameter.required()) {
            throw new ResultException(new CommandFailureArgumentMissing(parameter));
        }
        return Optional.ofNullable(parameter.defaultValue());
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public <T> @Nullable T getArgument(String name, Class<? extends T> argumentType) throws IllegalArgumentException, ClassCastException {
        if (!this.arguments.containsKey(name)) {
            throw new IllegalArgumentException(String.format("No parameter named '%s'.", name));
        }
        return this.arguments.get(name).getValue(argumentType);
    }

    @Override
    public boolean setContext(String key, @Nullable Object obj, boolean replace) {
        if (!replace && this.context.containsKey(key)) {
            return false;
        }
        this.context.put(key, obj);
        return true;
    }

    @Override
    public <T> @Nullable T getContext(String key, Class<? extends T> type) throws IllegalArgumentException, ClassCastException {
        if (!this.context.containsKey(key)) {
            throw new IllegalArgumentException(String.format("No context under key '%s'.", key));
        }
        return type.cast(this.context.get(key));
    }

    @Override
    public Mono<Void> load() throws ResultException {
        LOGGER.trace("Parsing arguments {} for parameters {}", this.rawArguments, this.parameterOrder);
        int received = this.rawArguments.size();
        int expected = this.parameterOrder.size();
        if (received > expected) {
            List<String> unexpected = this.rawArguments.stream().skip(expected).map(this::rawToString).toList();
            throw new ResultException(new CommandFailureArgumentExtra(unexpected));
        }
        Stream parsed = Streams.zip(this.parameterOrder.stream(), this.rawArguments.stream(), this::parseArgumentWrapped);
        Stream<Optional> missing = this.parameterOrder.stream().skip(received).map(ContextImpl::missingArgument);
        return Flux.concat(parsed.toList()).map(Optional::of).concatWith((Publisher)Flux.fromStream(missing)).zipWithIterable(this.parameterOrder).map(t -> Tuples.of((Object)((Parameter)t.getT2()).name(), (Object)((Optional)t.getT1()))).map(t -> Tuples.of((Object)this.arguments.get(t.getT1()), (Object)((Optional)t.getT2()))).doOnNext(t -> ((Argument)t.getT1()).setValue(((Optional)t.getT2()).orElse(null))).then().name("parameter-parse").metrics();
    }

    private static class Argument {
        private @Nullable Object value;

        Argument() {
        }

        public <T> @Nullable T getValue(Class<? extends T> argumentType) throws ClassCastException {
            return argumentType.cast(this.value);
        }

        public void setValue(@Nullable Object value) {
            this.value = value;
        }
    }
}

