/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.context.CommandContext;
import dev.sympho.modular_commands.api.command.context.LazyContext;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.result.CommandContinue;
import dev.sympho.modular_commands.api.command.result.CommandError;
import dev.sympho.modular_commands.api.command.result.CommandErrorException;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.Results;
import dev.sympho.modular_commands.api.exception.IncompleteHandlingException;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.execute.InvocationUtils;
import dev.sympho.modular_commands.execute.InvocationValidator;
import dev.sympho.modular_commands.execute.ResultException;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import java.util.List;
import java.util.Optional;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

public abstract class PipelineBuilder<E extends Event, C extends Command, CTX extends CommandContext & LazyContext, IH extends InvocationHandler, RH extends ResultHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineBuilder.class);

    public Mono<Void> buildPipeline(GatewayDiscordClient client, Registry registry) {
        Flux source = client.on(this.eventType()).onErrorStop().filter(this::eventFilter);
        return this.buildPipeline(source, registry);
    }

    @SideEffectFree
    private Mono<Void> buildPipeline(Flux<E> source, Registry registry) {
        return this.parsingPipeline(source, registry).flatMap(this::executeCommand).doOnNext(ctx -> {
            CommandContext context = (CommandContext)ctx.getT2();
            CommandResult result = (CommandResult)ctx.getT3();
            if (result instanceof CommandErrorException) {
                CommandErrorException r = (CommandErrorException)result;
                Throwable cause = r.cause();
                LOGGER.error(String.format("Exception while executing command %s", context.getInvocation()), cause);
            } else if (result instanceof CommandError) {
                CommandError r = (CommandError)result;
                LOGGER.error("Error while executing command {}: {}", (Object)context.getInvocation(), (Object)r.message());
            } else {
                LOGGER.debug("Finished command execution {} with result {}", (Object)context.getInvocation(), (Object)result.getClass().getSimpleName());
            }
        }).flatMap(this::handleResult).doOnNext(c -> LOGGER.warn("Handling of result of command {} not complete", (Object)c.getInvocation())).onErrorContinue((e, o) -> LOGGER.error("Exception thrown within processing pipeline", e)).then();
    }

    @Pure
    protected abstract Class<E> eventType();

    @Pure
    protected abstract Class<C> commandType();

    @Pure
    protected abstract boolean fullMatch();

    @Pure
    protected boolean eventFilter(E event) {
        return true;
    }

    @Pure
    protected abstract InvocationValidator<E> getValidator();

    @SideEffectFree
    protected abstract List<String> parse(E var1);

    @SideEffectFree
    protected abstract CTX makeContext(E var1, C var2, Invocation var3, List<String> var4);

    @SideEffectFree
    protected abstract Optional<Snowflake> getGuildId(E var1);

    @Pure
    protected abstract IH getInvocationHandler(C var1);

    protected abstract Mono<CommandResult> invoke(IH var1, CTX var2) throws Exception;

    @Pure
    protected abstract List<? extends RH> getResultHandlers(C var1);

    protected abstract Mono<Boolean> handle(RH var1, CTX var2, CommandResult var3);

    private Mono<CommandResult> invokeWrap(IH handler, CTX context) {
        try {
            return this.invoke(handler, context).onErrorResume(e -> Results.exceptionMono(e));
        }
        catch (Exception e2) {
            return Results.exceptionMono(e2);
        }
    }

    @Pure
    private boolean checkScope(Tuple4<E, List<C>, Invocation, List<String>> payload) {
        Event event = (Event)payload.getT1();
        List chain = (List)payload.getT2();
        Object command = InvocationUtils.getInvokedCommand(chain);
        return command.scope() == Command.Scope.GLOBAL || this.getGuildId(event).isPresent();
    }

    @Pure
    private boolean checkCallable(Tuple4<E, List<C>, Invocation, List<String>> payload) {
        List chain = (List)payload.getT2();
        Object command = InvocationUtils.getInvokedCommand(chain);
        return command.callable();
    }

    @SideEffectFree
    private Flux<Tuple4<E, List<C>, Invocation, List<String>>> parsingPipeline(Flux<E> source, Registry registry) {
        return source.map(e -> Tuples.of((Object)e, this.parse(e))).filter(ctx -> !((List)ctx.getT2()).isEmpty()).mapNotNull(ctx -> {
            Event event = (Event)ctx.getT1();
            List args = (List)ctx.getT2();
            List<C> chain = InvocationUtils.makeChain(registry, args, this.commandType());
            Invocation invocation = new Invocation(args.subList(0, chain.size()));
            List remainder = args.subList(chain.size(), args.size());
            if (this.fullMatch() && !remainder.isEmpty()) {
                throw new IllegalStateException("No full match found: " + remainder.toString() + " was leftover from " + args.toString());
            }
            return Tuples.of((Object)event, chain, (Object)invocation, remainder);
        }).filter(ctx -> !((List)ctx.getT2()).isEmpty()).filter(this::checkScope).filter(this::checkCallable).name("command-parse").metrics();
    }

    @SideEffectFree
    private Mono<Void> validateCommand(E event, List<? extends Command> chain) {
        InvocationValidator<E> validator = this.getValidator();
        return validator.validateSettings(event, chain).thenEmpty(validator.validateDiscordPermissions(event, chain)).name("command-validate").metrics();
    }

    private boolean verifyHandled(CommandResult result, List<C> chain, CTX context) throws IncompleteHandlingException {
        if (result instanceof CommandContinue) {
            throw new IncompleteHandlingException(chain, context.getInvocation());
        }
        return true;
    }

    private Mono<CommandResult> invokeCommand(List<C> chain, CTX context) {
        Invocation invocation = InvocationUtils.getInvokedCommand(chain).invocation();
        LOGGER.debug("Invoking command {}", (Object)invocation);
        List<InvocationHandler> handlers = InvocationUtils.accumulateHandlers(chain, this::getInvocationHandler);
        LOGGER.trace("Handlers for {}: {}", (Object)invocation, handlers);
        Mono state = Results.contMono();
        for (InvocationHandler handler : handlers) {
            state = state.flatMap(r -> {
                if (r instanceof CommandContinue) {
                    LOGGER.trace("Invoking command handler for {}", (Object)invocation);
                    return this.invokeWrap(handler, context);
                }
                LOGGER.trace("Skipping command handler for {}", (Object)invocation);
                return Mono.just((Object)r);
            });
        }
        return state.filter(r -> this.verifyHandled((CommandResult)r, chain, context)).name("command-invoke").metrics();
    }

    private Mono<Tuple3<C, CTX, CommandResult>> executeCommand(Tuple4<E, List<C>, Invocation, List<String>> payload) {
        Event event = (Event)payload.getT1();
        List chain = (List)payload.getT2();
        Invocation invocation = (Invocation)payload.getT3();
        List args = (List)payload.getT4();
        Object command = InvocationUtils.getInvokedCommand(chain);
        Object context = this.makeContext(event, command, invocation, args);
        return this.validateCommand(event, chain).thenReturn(context).flatMap(ctx -> ((LazyContext)ctx).load().thenReturn(ctx)).flatMap(ctx -> this.invokeCommand(chain, ctx)).onErrorResume(ResultException.class, e -> Mono.just((Object)e.getResult())).map(result -> Tuples.of((Object)command, (Object)context, (Object)result)).name("command-execute").metrics();
    }

    private Mono<CTX> handleResult(Tuple3<C, CTX, CommandResult> payload) {
        Command command = (Command)payload.getT1();
        CommandContext context = (CommandContext)payload.getT2();
        CommandResult result = (CommandResult)payload.getT3();
        Mono state = Mono.just((Object)context);
        for (ResultHandler handler : this.getResultHandlers(command)) {
            state = state.filterWhen(c -> this.handle(handler, c, result));
        }
        return state.name("command-result").metrics();
    }
}

