/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.MessageCommand;
import dev.sympho.modular_commands.api.command.handler.MessageInvocationHandler;
import dev.sympho.modular_commands.api.command.handler.MessageResultHandler;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.registry.Registry;
import dev.sympho.modular_commands.execute.CommandExecutor;
import dev.sympho.modular_commands.execute.InvocationValidator;
import dev.sympho.modular_commands.execute.PipelineBuilder;
import dev.sympho.modular_commands.execute.PrefixProvider;
import dev.sympho.modular_commands.impl.context.MessageContextImpl;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class MessageCommandExecutor
extends CommandExecutor {
    private static final Validator validator = new Validator();

    public MessageCommandExecutor(GatewayDiscordClient client, Registry registry, PrefixProvider prefixProvider) {
        super(client, registry, new Builder(prefixProvider));
    }

    private static class Builder
    extends PipelineBuilder<MessageCreateEvent, MessageCommand, MessageContextImpl, MessageInvocationHandler, MessageResultHandler> {
        private final PrefixProvider prefixProvider;

        Builder(PrefixProvider prefixProvider) {
            this.prefixProvider = prefixProvider;
        }

        @Override
        protected Class<MessageCreateEvent> eventType() {
            return MessageCreateEvent.class;
        }

        @Override
        protected Class<MessageCommand> commandType() {
            return MessageCommand.class;
        }

        @Override
        protected boolean fullMatch() {
            return false;
        }

        @Override
        protected boolean eventFilter(MessageCreateEvent event) {
            return event.getMessage().getAuthor().isPresent();
        }

        @Override
        protected InvocationValidator<MessageCreateEvent> getValidator() {
            return validator;
        }

        private static int nextWhitespace(String message) {
            for (int i = 0; i < message.length(); ++i) {
                if (!Character.isWhitespace(message.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        private static int nextClose(String message, Character delim) {
            int cur = 1;
            while (cur >= 0) {
                cur = message.indexOf(delim.charValue(), cur);
                if (cur < 0 || cur != message.length() - 1 && !Character.isWhitespace(message.charAt(cur + 1))) continue;
                return cur;
            }
            return -1;
        }

        private static Tuple2<String, String> nextArg(String message) {
            int nextStart;
            int endIdx;
            int startIdx = 1;
            if (message.startsWith("\"")) {
                endIdx = Builder.nextClose(message, Character.valueOf('\"'));
            } else if (message.startsWith("'")) {
                endIdx = Builder.nextClose(message, Character.valueOf('\''));
            } else {
                startIdx = 0;
                endIdx = Builder.nextWhitespace(message);
            }
            if (endIdx < 0) {
                startIdx = 0;
                endIdx = message.length();
                nextStart = message.length();
            } else {
                nextStart = endIdx + 1;
            }
            return Tuples.of((Object)message.substring(startIdx, endIdx), (Object)message.substring(nextStart).trim());
        }

        @Override
        protected List<String> parse(MessageCreateEvent event) {
            String prefix;
            String message = event.getMessage().getContent().trim();
            if (!message.startsWith(prefix = this.prefixProvider.getPrefix(event.getGuildId().orElse(null)))) {
                return Collections.emptyList();
            }
            message = message.substring(prefix.length());
            LinkedList<String> args = new LinkedList<String>();
            while (!message.isEmpty()) {
                Tuple2<String, String> next = Builder.nextArg(message);
                args.add((String)next.getT1());
                message = (String)next.getT2();
            }
            return args;
        }

        @Override
        protected MessageContextImpl makeContext(MessageCreateEvent event, MessageCommand command, Invocation invocation, List<String> args) {
            return new MessageContextImpl(event, invocation, command.parameters(), args);
        }

        @Override
        protected Optional<Snowflake> getGuildId(MessageCreateEvent event) {
            return event.getGuildId();
        }

        @Override
        protected MessageInvocationHandler getInvocationHandler(MessageCommand command) {
            return command.invocationHandler();
        }

        @Override
        protected Mono<CommandResult> invoke(MessageInvocationHandler handler, MessageContextImpl context) throws Exception {
            return handler.handle(context);
        }

        @Override
        protected List<? extends MessageResultHandler> getResultHandlers(MessageCommand command) {
            return command.resultHandlers();
        }

        @Override
        protected Mono<Boolean> handle(MessageResultHandler handler, MessageContextImpl context, CommandResult result) {
            return handler.handle(context, result);
        }
    }

    private static class Validator
    extends InvocationValidator<MessageCreateEvent> {
        Validator() {
        }

        @Override
        protected User getCaller(MessageCreateEvent event) {
            Optional author = event.getMessage().getAuthor();
            return (User)author.get();
        }

        @Override
        protected Mono<MessageChannel> getChannel(MessageCreateEvent event) {
            return event.getMessage().getChannel();
        }

        @Override
        protected Mono<Guild> getGuild(MessageCreateEvent event) {
            return event.getGuild();
        }
    }
}

