/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.result.CommandResult;
import dev.sympho.modular_commands.api.command.result.Results;
import dev.sympho.modular_commands.execute.InvocationUtils;
import dev.sympho.modular_commands.execute.ResultException;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.entity.channel.TextChannel;
import discord4j.rest.util.PermissionSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.util.NullnessUtil;
import reactor.core.publisher.Mono;

public abstract class InvocationValidator<E extends Event> {
    private final List<Validator<?>> validators = List.of(new NsfwValidator(), new ServerOwnerValidator(), new BotOwnerValidator());

    protected abstract User getCaller(E var1);

    protected abstract Mono<MessageChannel> getChannel(E var1);

    protected abstract Mono<Guild> getGuild(E var1);

    public Mono<Void> validateSettings(E event, List<? extends Command> chain) {
        Command command = InvocationUtils.getSettingsSource(chain);
        Mono state = Mono.empty();
        for (Validator<?> validator : this.validators) {
            state = state.thenEmpty(validator.validate(command, event));
        }
        return state;
    }

    private Mono<PermissionSet> getChannelPermissions(MessageChannel channel, User user) {
        if (channel instanceof GuildChannel) {
            GuildChannel c = (GuildChannel)channel;
            return c.getEffectivePermissions(user.getId());
        }
        return Mono.empty();
    }

    public Mono<Void> validateDiscordPermissions(E event, List<? extends Command> chain) {
        PermissionSet required = InvocationUtils.accumulateDiscordPermissions(chain);
        if (required.isEmpty()) {
            return Mono.empty();
        }
        return this.getChannel(event).flatMap(c -> this.getChannelPermissions((MessageChannel)c, this.getCaller(event))).map(arg_0 -> ((PermissionSet)required).andNot(arg_0)).filter(Predicate.not(Collection::isEmpty)).map(m -> "Missing permissions: " + m.toString()).map(Results::failure).doOnNext(r -> {
            throw new ResultException((CommandResult)r);
        }).then();
    }

    private final class NsfwValidator
    extends Validator<MessageChannel> {
        NsfwValidator() {
        }

        @Override
        public boolean active(Command command) {
            return command.nsfw();
        }

        @Override
        public Mono<MessageChannel> getValue(E event) {
            return InvocationValidator.this.getChannel(event);
        }

        @Override
        public @Nullable String validate(User caller, MessageChannel channel) {
            TextChannel ch;
            if (channel instanceof TextChannel && (ch = (TextChannel)channel).isNsfw()) {
                return null;
            }
            return "Command can only be called from a NSFW channel.";
        }
    }

    private final class ServerOwnerValidator
    extends Validator<Guild> {
        ServerOwnerValidator() {
        }

        @Override
        public boolean active(Command command) {
            return command.serverOwnerOnly();
        }

        @Override
        public Mono<Guild> getValue(E event) {
            return InvocationValidator.this.getGuild(event);
        }

        @Override
        public @Nullable String validate(User caller, Guild guild) {
            if (guild.getOwnerId().equals((Object)caller.getId())) {
                return null;
            }
            return "Must be server owner to call this command.";
        }
    }

    private final class BotOwnerValidator
    extends Validator<ApplicationInfo> {
        BotOwnerValidator() {
        }

        @Override
        public boolean active(Command command) {
            return command.botOwnerOnly();
        }

        @Override
        public Mono<ApplicationInfo> getValue(E event) {
            return event.getClient().getApplicationInfo();
        }

        @Override
        public @Nullable String validate(User caller, ApplicationInfo guild) {
            if (guild.getOwnerId().equals((Object)caller.getId())) {
                return null;
            }
            return "Must be bot owner to call this command.";
        }
    }

    private abstract class Validator<T> {
        private Validator() {
        }

        protected abstract boolean active(Command var1);

        protected abstract Mono<T> getValue(E var1);

        protected abstract @Nullable String validate(User var1, T var2);

        public Mono<Void> validate(Command command, E event) {
            if (this.active(command)) {
                return this.getValue(event).mapNotNull(v -> (String)NullnessUtil.castNonNull((Object)this.validate(InvocationValidator.this.getCaller(event), v))).map(Results::failure).doOnNext(r -> {
                    throw new ResultException((CommandResult)r);
                }).then();
            }
            return Mono.empty();
        }
    }
}

