/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.execute;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.exception.InvalidChainException;
import dev.sympho.modular_commands.api.registry.Registry;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class InvocationUtils {
    private InvocationUtils() {
    }

    @SideEffectFree
    public static <C extends Command> List<C> makeChain(Registry registry, List<String> args, Class<? extends C> commandType) {
        String arg;
        Invocation next;
        C command;
        LinkedList<C> chain = new LinkedList<C>();
        Invocation current = Invocation.of(new String[0]);
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext() && (command = registry.findCommand(next = current.child(arg = iterator.next()), commandType)) != null) {
            chain.add(command);
            current = current.child(command.name());
        }
        return new ArrayList(chain);
    }

    @Pure
    public static <C extends Command> C getInvokedCommand(List<? extends C> chain) {
        return (C)((Command)chain.get(chain.size() - 1));
    }

    @Pure
    public static Command getSettingsSource(List<? extends Command> chain) {
        ListIterator<? extends Command> settingIt = chain.listIterator(chain.size());
        Command settingsSource = settingIt.previous();
        while (settingIt.hasPrevious() && settingsSource.inheritSettings()) {
            settingsSource = settingIt.previous();
        }
        return settingsSource;
    }

    @SideEffectFree
    public static PermissionSet accumulateDiscordPermissions(List<? extends Command> chain) {
        ListIterator<? extends Command> permIt = chain.listIterator(chain.size());
        Command permSource = permIt.previous();
        PermissionSet permissions = permSource.requiredDiscordPermissions();
        while (permIt.hasPrevious() && permSource.requireParentPermissions()) {
            permSource = permIt.previous();
            permissions = permissions.or(permSource.requiredDiscordPermissions());
        }
        return permissions;
    }

    @SideEffectFree
    public static <C extends Command, IH extends InvocationHandler> List<IH> accumulateHandlers(List<C> chain, Function<C, IH> getter) throws InvalidChainException {
        LinkedList<InvocationHandler> handlers = new LinkedList<InvocationHandler>();
        ListIterator<C> it = chain.listIterator(chain.size());
        Command source = (Command)it.previous();
        handlers.add((InvocationHandler)getter.apply(source));
        Command target = source;
        Set satisfiedParameters = source.parameters().stream().filter(p -> p.required() || p.defaultValue() != null).map(Parameter::name).collect(Collectors.toSet());
        Map<String, Class> parameterTypes = source.parameters().stream().collect(Collectors.toMap(Parameter::name, Object::getClass));
        while (it.hasPrevious() && source.invokeParent()) {
            source = (Command)it.previous();
            for (Parameter<?> p2 : source.parameters()) {
                Class receivedType = parameterTypes.get(p2.name());
                if (receivedType != null && receivedType != p2.getClass()) {
                    throw new InvalidChainException(source, target, String.format("Parameter %s is of type %s in parent but type %s in child", p2.name(), p2.getClass().getSimpleName(), receivedType.getSimpleName()));
                }
                if (!p2.required() || satisfiedParameters.contains(p2.name())) continue;
                throw new InvalidChainException(source, target, String.format("Parameter %s is required in parent but may not be present in child", p2.name()));
            }
            handlers.add(0, (InvocationHandler)getter.apply(source));
        }
        return new ArrayList(handlers);
    }
}

