/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.exception;

import dev.sympho.modular_commands.api.command.Command;
import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.exception.CommandException;
import dev.sympho.modular_commands.execute.InvocationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.dataflow.qual.Pure;

public class IncompleteHandlingException
extends CommandException {
    private static final long serialVersionUID = -6242043843932336667L;
    private final List<Command> chain;
    private final Invocation invocation;

    public IncompleteHandlingException(List<? extends Command> chain, Invocation invocation) {
        super(String.format("Command %s under invocation %s was not completely handled.", InvocationUtils.getInvokedCommand(chain).invocation(), invocation));
        this.chain = Collections.unmodifiableList(new ArrayList<Command>(chain));
        this.invocation = invocation;
    }

    @Pure
    public Command getCommand() {
        return InvocationUtils.getInvokedCommand(this.chain);
    }

    @Pure
    public List<Command> getExecutionChain() {
        return this.chain;
    }

    @Pure
    public Invocation getInvocation() {
        return this.invocation;
    }
}

