/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter;

import dev.sympho.modular_commands.api.command.parameter.ChoicesParameter;
import dev.sympho.modular_commands.utils.ParameterUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class StringParameter
extends Record
implements ChoicesParameter<String> {
    private final String name;
    private final String description;
    private final boolean required;
    private final @Nullable String defaultValue;
    private final Map<String, String> choices;

    @SideEffectFree
    public StringParameter(String name, String description, boolean required, @Nullable String defaultValue, @Nullable Map<String, String> choices) {
        this.name = ParameterUtils.validateName(name);
        this.description = ParameterUtils.validateDescription(description);
        this.required = required;
        this.defaultValue = defaultValue;
        this.choices = ParameterUtils.validateChoices(choices);
        if (this.choices.values().stream().anyMatch(String::isEmpty)) {
            throw new IllegalArgumentException("A choice cannot be empty.");
        }
    }

    @SideEffectFree
    public StringParameter(String name, String description, boolean required, @Nullable String defaultValue) {
        this(name, description, required, defaultValue, null);
    }

    @Override
    public String parseValue(String raw) throws IllegalArgumentException {
        return raw;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{StringParameter.class, "name;description;required;defaultValue;choices", "name", "description", "required", "defaultValue", "choices"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StringParameter.class, "name;description;required;defaultValue;choices", "name", "description", "required", "defaultValue", "choices"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StringParameter.class, "name;description;required;defaultValue;choices", "name", "description", "required", "defaultValue", "choices"}, this, o);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public @Nullable String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Map<String, String> choices() {
        return this.choices;
    }
}

