/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter;

import dev.sympho.modular_commands.api.command.parameter.ChoicesParameter;
import dev.sympho.modular_commands.api.exception.InvalidArgumentException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface NumberParameter<T extends @NonNull Number>
extends ChoicesParameter<T> {
    @Pure
    public T minimum();

    @Pure
    public T maximum();

    @SideEffectFree
    public T parseNumber(String var1) throws NumberFormatException;

    @Override
    default public T parseValue(String raw) throws InvalidArgumentException {
        try {
            T value = this.parseNumber(raw);
            if (((Comparable)this.minimum()).compareTo(value) <= 0 && ((Comparable)this.maximum()).compareTo(value) >= 0) {
                return value;
            }
            throw new InvalidArgumentException(this, String.format("Value %s is not within the range [%s, %s].", raw, this.minimum().toString(), this.maximum().toString()));
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(this, String.format("Value '%s' is not a valid number.", raw), e);
        }
    }
}

