/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter;

import dev.sympho.modular_commands.api.command.parameter.NumberParameter;
import dev.sympho.modular_commands.utils.ParameterUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class IntegerParameter
extends Record
implements NumberParameter<Long> {
    private final String name;
    private final String description;
    private final boolean required;
    private final @Nullable Long defaultValue;
    private final Map<String, Long> choices;
    private final Long minimum;
    private final Long maximum;

    @SideEffectFree
    public IntegerParameter(String name, String description, boolean required, @Nullable Long defaultValue, @Nullable Map<String, Long> choices, @Nullable Long minimum, @Nullable Long maximum) {
        this.name = ParameterUtils.validateName(name);
        this.description = ParameterUtils.validateDescription(description);
        this.required = required;
        this.defaultValue = defaultValue;
        this.choices = ParameterUtils.validateChoices(choices);
        this.minimum = Objects.requireNonNullElse(minimum, Long.MIN_VALUE);
        this.maximum = Objects.requireNonNullElse(maximum, Long.MAX_VALUE);
        if (this.minimum > this.maximum) {
            throw new IllegalArgumentException("Empty numeric range");
        }
    }

    @SideEffectFree
    public IntegerParameter(String name, String description, boolean required, @Nullable Long defaultValue) {
        this(name, description, required, defaultValue, null, null, null);
    }

    @SideEffectFree
    public IntegerParameter(String name, String description, boolean required, @Nullable Long defaultValue, Map<String, Long> choices) throws IllegalArgumentException {
        this(name, description, required, defaultValue, choices, null, null);
    }

    @SideEffectFree
    public IntegerParameter(String name, String description, boolean required, @Nullable Long defaultValue, long minimum, long maximum) throws IllegalArgumentException {
        this(name, description, required, defaultValue, null, minimum, maximum);
    }

    @Override
    public Long parseNumber(String raw) throws NumberFormatException {
        return Long.parseLong(raw);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerParameter.class, "name;description;required;defaultValue;choices;minimum;maximum", "name", "description", "required", "defaultValue", "choices", "minimum", "maximum"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerParameter.class, "name;description;required;defaultValue;choices;minimum;maximum", "name", "description", "required", "defaultValue", "choices", "minimum", "maximum"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerParameter.class, "name;description;required;defaultValue;choices;minimum;maximum", "name", "description", "required", "defaultValue", "choices", "minimum", "maximum"}, this, o);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public @Nullable Long defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Map<String, Long> choices() {
        return this.choices;
    }

    @Override
    public Long minimum() {
        return this.minimum;
    }

    @Override
    public Long maximum() {
        return this.maximum;
    }
}

