/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter;

import dev.sympho.modular_commands.api.command.parameter.NumberParameter;
import dev.sympho.modular_commands.utils.ParameterUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class FloatParameter
extends Record
implements NumberParameter<Double> {
    private final String name;
    private final String description;
    private final boolean required;
    private final @Nullable Double defaultValue;
    private final Map<String, Double> choices;
    private final Double minimum;
    private final Double maximum;

    @SideEffectFree
    public FloatParameter(String name, String description, boolean required, @Nullable Double defaultValue, @Nullable Map<String, Double> choices, @Nullable Double minimum, @Nullable Double maximum) {
        this.name = ParameterUtils.validateName(name);
        this.description = ParameterUtils.validateDescription(description);
        this.required = required;
        this.defaultValue = defaultValue;
        this.choices = ParameterUtils.validateChoices(choices);
        this.minimum = Objects.requireNonNullElse(minimum, Double.NEGATIVE_INFINITY);
        this.maximum = Objects.requireNonNullElse(maximum, Double.POSITIVE_INFINITY);
        if (this.minimum.isNaN() || this.maximum.isNaN() || this.choices.values().stream().anyMatch(c -> c.isNaN())) {
            throw new IllegalArgumentException("NaN is not a valid parameter value.");
        }
        if (this.minimum > this.maximum) {
            throw new IllegalArgumentException("Empty numeric range");
        }
    }

    @SideEffectFree
    public FloatParameter(String name, String description, boolean required, @Nullable Double defaultValue) {
        this(name, description, required, defaultValue, null, null, null);
    }

    @SideEffectFree
    public FloatParameter(String name, String description, boolean required, @Nullable Double defaultValue, Map<String, Double> choices) throws IllegalArgumentException {
        this(name, description, required, defaultValue, choices, null, null);
    }

    @SideEffectFree
    public FloatParameter(String name, String description, boolean required, @Nullable Double defaultValue, double minimum, double maximum) throws IllegalArgumentException {
        this(name, description, required, defaultValue, null, minimum, maximum);
    }

    @Override
    public Double parseNumber(String raw) throws NumberFormatException {
        return Double.parseDouble(raw);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatParameter.class, "name;description;required;defaultValue;choices;minimum;maximum", "name", "description", "required", "defaultValue", "choices", "minimum", "maximum"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatParameter.class, "name;description;required;defaultValue;choices;minimum;maximum", "name", "description", "required", "defaultValue", "choices", "minimum", "maximum"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatParameter.class, "name;description;required;defaultValue;choices;minimum;maximum", "name", "description", "required", "defaultValue", "choices", "minimum", "maximum"}, this, o);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public @Nullable Double defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Map<String, Double> choices() {
        return this.choices;
    }

    @Override
    public Double minimum() {
        return this.minimum;
    }

    @Override
    public Double maximum() {
        return this.maximum;
    }
}

