/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command.parameter;

import dev.sympho.modular_commands.api.command.parameter.Parameter;
import dev.sympho.modular_commands.api.exception.InvalidArgumentException;
import java.util.Map;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ChoicesParameter<T>
extends Parameter<T> {
    @Pure
    public Map<String, T> choices();

    @SideEffectFree
    public T parseValue(String var1) throws InvalidArgumentException;

    @Override
    default public Mono<T> parse(String raw) throws InvalidArgumentException {
        T value = this.parseValue(raw);
        if (this.choices().isEmpty() || this.choices().containsValue(value)) {
            return Mono.just(value);
        }
        throw new InvalidArgumentException(this, String.format("Value '%s' is not a valid choice.", raw));
    }
}

